﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Cn_Controls_ProductView : System.Web.UI.UserControl
{
    protected string ProductName;
    protected string ProductModel;
    protected decimal ProductPrice;
    protected string ProductBody;
    protected string PicPath2;
    protected string PicPath1;
    private SnSee.Bean.UserBaseBean _UserBaseBean = null;

    /// <summary>
    /// 语言版本标识
    /// </summary>
    private string _EditionKey;
    /// <summary>
    /// 语言版本标识
    /// </summary>
    public string EditionKey
    {
        get
        {
            if (string.IsNullOrEmpty(_EditionKey))
            {
                if (Request.QueryString["EditionKey"] != null)
                {
                    _EditionKey = Request.QueryString["EditionKey"];
                }
                else if (!string.IsNullOrEmpty(SnSee.Config.WebConfig.EditionKey))
                {
                    _EditionKey = SnSee.Config.WebConfig.EditionKey;
                }
            }
            return _EditionKey;
        }
        set
        {
            _EditionKey = value;
        }
    }

    /// <summary>
    /// 产品ID
    /// </summary>
    private Guid? _ProductBaseID;
    /// <summary>
    /// 产品ID
    /// </summary>
    public Guid? ProductBaseID
    {
        get
        {
            if (Request.QueryString["ProductBaseID"] != null)
            {
                _ProductBaseID = SnSee.Tool.ConvertTool.GetGuid(Request.QueryString["ProductBaseID"]);
            }
            return _ProductBaseID;
        }
        set
        {
            _ProductBaseID = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Bean.EditionBean _EditionBean = null;
        if (!string.IsNullOrEmpty(EditionKey))
        {
            _EditionBean = (SnSee.Bean.EditionBean)SnSee.Factory.Factory.Edition.Select("EditionKey='" + EditionKey + "' And State=1");
        }

        if (_EditionBean != null && ProductBaseID.HasValue)
        {
            SnSee.Module.User.User.UserIsLogin(out _UserBaseBean, false, null);
            if (!SnSee.Module.Product.ProductBase.CheckViewUserLevel(_UserBaseBean, null, ProductBaseID, _EditionBean.ID.Value))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "您沒有許可權訪問當前頁面！", "Login.aspx");
                return;
            }
            GetProduct(_EditionBean.ID.Value, ProductBaseID.Value);
            GetProductAttribute(_EditionBean.ID.Value, ProductBaseID.Value);
        }
    }

    /// <summary>
    /// 取得产品数据
    /// </summary>
    /// <param name="EditionID">语言标识ID</param>
    /// <param name="ProductBaseID">产品ID</param>
    private void GetProduct(Guid EditionID, Guid ProductBaseID)
    {
        SnSee.Bean.ProductBaseBean _ProductBaseBean = (SnSee.Bean.ProductBaseBean)SnSee.Factory.Factory.ProductBase.Select(ProductBaseID);
        if (_ProductBaseBean != null)
        {
            PicPath2 = _ProductBaseBean.PicPath2;
            PicPath1 = _ProductBaseBean.PicPath1;
        }

        SnSee.Bean.ProductListBean _ProductListBean = (SnSee.Bean.ProductListBean)SnSee.Factory.Factory.ProductList.Select("ProductBaseID='{" + ProductBaseID + "}' And EditionID='{" + EditionID + "}'");
        if (_ProductListBean != null)
        {
            ProductName = _ProductListBean.Name;
            ProductModel = _ProductListBean.Model;
            if (_ProductListBean.Price.HasValue)
            {
                ProductPrice = _ProductListBean.Price.Value;
            }
            ProductBody = _ProductListBean.Body;
        }
    }

    /// <summary>
    /// 取得产品参数数据
    /// </summary>
    /// <param name="EditionID">语言标识ID</param>
    /// <param name="ProductBaseID">产品ID</param>
    private void GetProductAttribute(Guid EditionID, Guid ProductBaseID)
    {
        int RowCount = 0;
        ProductAttributeList.DataSource = SnSee.Factory.Factory.ProductAttributeList.GetProductAttributeListPage(1, 9999, "ProductAttributeList.EditionID='{" + EditionID + "}' And ProductAttributeList.ProductBaseID='{" + ProductBaseID + "}' And ProductAttributeList.State=1", "Order By ProductAttribute.SortOrder Asc", out RowCount);
        ProductAttributeList.DataBind();
    }
}
