﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;

public partial class Cn_Controls_SalesList : System.Web.UI.UserControl
{
    /// <summary>
    /// 搜索关键词
    /// </summary>
    private string Keyword;

    /// <summary>
    /// 当前活动
    /// </summary>
    private string ActionType;

    /// <summary>
    /// 语言版本标识
    /// </summary>
    private string _EditionKey;
    /// <summary>
    /// 语言版本标识
    /// </summary>
    public string EditionKey
    {
        get
        {
            if (string.IsNullOrEmpty(_EditionKey))
            {
                if (Request.QueryString["EditionKey"] != null)
                {
                    _EditionKey = Request.QueryString["EditionKey"];
                }
                else if (!string.IsNullOrEmpty(SnSee.Config.WebConfig.EditionKey))
                {
                    _EditionKey = SnSee.Config.WebConfig.EditionKey;
                }
            }
            return _EditionKey;
        }
        set
        {
            _EditionKey = value;
        }
    }

    /// <summary>
    /// 销售网络分类ID
    /// </summary>
    private Guid? _SalesClassID;
    /// <summary>
    /// 销售网络分类ID
    /// </summary>
    public Guid? SalesClassID
    {
        get
        {
            if (Request.QueryString["SalesClassID"] != null)
            {
                _SalesClassID = SnSee.Tool.ConvertTool.GetGuid(Request.QueryString["SalesClassID"]);
            }
            return _SalesClassID;
        }
        set
        {
            _SalesClassID = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        EditionBean _EditionBean = null;
        if (!string.IsNullOrEmpty(EditionKey))
        {
            _EditionBean = (EditionBean)SnSee.Factory.Factory.Edition.Select("EditionKey='" + EditionKey + "' And State=1");
        }

        Keyword = Request.QueryString["Keyword"];   //取得搜索关健词
        ActionType = Request.QueryString["Action"]; //取得当前活动标识

        if (string.IsNullOrEmpty(ActionType) || (!string.IsNullOrEmpty(ActionType) && ActionType.ToLower() != "search"))
        {//只有当当前活动不为搜索时才执行自动取排序为第一的销售网络分类ID
            if (!SalesClassID.HasValue && _EditionBean != null)
            {//如果不存在销售网络分类ID,则取排序为第一的销售网络分类ID
                List<object> _SalesClassBeanList = SnSee.Factory.Factory.SalesClass.SelectList(1, "State=1 And IsChild=-1 And EditionID='{" + _EditionBean.ID.Value + "}'", "Order By SortOrder Asc");
                if (_SalesClassBeanList != null && _SalesClassBeanList.Count > 0)
                {
                    SnSee.Bean.SalesClassBean _SalesClassBean = (SnSee.Bean.SalesClassBean)_SalesClassBeanList[0];
                    if (_SalesClassBean != null)
                    {
                        SalesClassID = _SalesClassBean.ID;
                    }
                }
            }
        }

        string Where = "SalesBase.State=1";//查询条件
        if (_EditionBean != null)
        {
            Where += " And SalesClass.EditionID='{" + _EditionBean.ID.Value + "}'";
        }
        if (SalesClassID.HasValue)
        {
            Where += " And SalesBase.SalesClassID='{" + SalesClassID.Value + "}'";
        }
        if (!string.IsNullOrEmpty(Keyword))
        {
            Keyword = SnSee.Tool.StringTool.FilterString(Keyword);
            Where += " And (SalesBase.Title Like '%" + Keyword + "%' Or SalesBase.Address Like '%" + Keyword + "%' Or SalesBase.Contact Like '%" + Keyword + "%' Or SalesBase.Telephone Like '%" + Keyword + "%')";
        }
        SalesList_DataBind(WebPage1.PageIndex, WebPage1.PageSize, Where, "Order By SalesBase.SortOrder Asc");
    }

    /// <summary>
    /// 取得销售网络列表
    /// </summary>
    /// <param name="_PageIndex">当前页码</param>
    /// <param name="_PageSize">一页最大条数</param>
    /// <param name="_Where">条件</param>
    /// <param name="_OrderBy">排序方式</param>
    private void SalesList_DataBind(int _PageIndex, int _PageSize, string _Where, string _OrderBy)
    {
        int _RowCount = 0;
        SalesList.DataSource = SnSee.Factory.Factory.SalesBase.GetSalesListPage(_PageIndex, _PageSize, _Where, _OrderBy, out _RowCount);
        SalesList.DataBind();
        WebPage1.RecordCount = _RowCount;
    }
}
