﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class CN_Controls_UserGetPasswordView : System.Web.UI.UserControl
{
    SnSee.Bean.EditionBean _EditionBean;

    /// <summary>
    /// 语言版本标识
    /// </summary>
    private string _EditionKey;
    /// <summary>
    /// 语言版本标识
    /// </summary>
    public string EditionKey
    {
        get
        {
            if (string.IsNullOrEmpty(_EditionKey))
            {
                if (Request.QueryString["EditionKey"] != null)
                {
                    _EditionKey = Request.QueryString["EditionKey"];
                }
                else if (!string.IsNullOrEmpty(SnSee.Config.WebConfig.EditionKey))
                {
                    _EditionKey = SnSee.Config.WebConfig.EditionKey;
                }
            }
            return _EditionKey;
        }
        set
        {
            _EditionKey = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!string.IsNullOrEmpty(EditionKey))
        {
            _EditionBean = (SnSee.Bean.EditionBean)SnSee.Factory.Factory.Edition.Select("EditionKey='" + EditionKey + "' And State=1");
        }
    }

    /// <summary>
    /// 检查
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCheckUserName_Click(object sender, EventArgs e)
    {
        string UserName = txtUserName.Text;
        if (string.IsNullOrEmpty(UserName))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您還未輸入會員名稱！");
            return;
        }

        UserName = SnSee.Tool.StringTool.FilterString(UserName);//过滤恶意字符
        SnSee.Bean.UserBaseBean _UserBaseBean = (SnSee.Bean.UserBaseBean)SnSee.Factory.Factory.UserBase.Select("UserName='" + UserName + "'");
        if (_UserBaseBean == null)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您輸入的會員名稱不存在！");
            return;
        }
        if (string.IsNullOrEmpty(_UserBaseBean.PasswordQuestion))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您輸入的會員名稱沒有設置密碼問題！");
            return;
        }

        txtUserName.ReadOnly = true;
        litPasswordQuestion.Text = _UserBaseBean.PasswordQuestion;
    }

    /// <summary>
    /// 下一步
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnNext_Click(object sender, EventArgs e)
    {
        if (_EditionBean == null)
        {
            return;
        }

        if (rbtnType.Checked)
        {
            string UserName = txtUserName.Text;
            string PasswordAnswer = txtPasswordAnswer.Text;

            if (string.IsNullOrEmpty(UserName))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "您還未輸入會員名稱！");
                return;
            }

            UserName = SnSee.Tool.StringTool.FilterString(UserName);//过滤恶意字符
            SnSee.Bean.UserBaseBean _UserBaseBean = (SnSee.Bean.UserBaseBean)SnSee.Factory.Factory.UserBase.Select("UserName='" + UserName + "'");
            if (_UserBaseBean == null)
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "您輸入的會員名稱不存在！");
                return;
            }
            if (string.IsNullOrEmpty(_UserBaseBean.PasswordQuestion))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "您輸入的會員名稱沒有設置密碼問題！");
                return;
            }
            if (string.IsNullOrEmpty(PasswordAnswer))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "您還未輸入密碼問題答案！");
                return;
            }

            if (_UserBaseBean.PasswordAnswer == PasswordAnswer)
            {
                litMessage.Text = "恭喜您，密碼找回成功，您的密碼是：" + SnSee.Module.User.User.GetUserPassword(_UserBaseBean.UserPwd);
            }
            else
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "密碼問題與密碼答案不匹配，請核實後重試！");
                return;
            }
        }
        else if (rbtnType2.Checked)
        {
            if (SnSee.Config.EmailConfig.PasswordOpen)
            {
                string UserName = txtUserName2.Text;
                string Email = txtEmail.Text;

                if (string.IsNullOrEmpty(UserName))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "您還未輸入會員名稱！");
                    return;
                }

                UserName = SnSee.Tool.StringTool.FilterString(UserName);//过滤恶意字符
                SnSee.Bean.UserBaseBean _UserBaseBean = (SnSee.Bean.UserBaseBean)SnSee.Factory.Factory.UserBase.Select("UserName='" + UserName + "'");
                if (_UserBaseBean == null)
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "您輸入的會員名稱不存在！");
                    return;
                }

                if (string.IsNullOrEmpty(Email))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "您還未輸入電子郵箱位址！");
                    return;
                }

                string emailTest = @"\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*";
                if (!System.Text.RegularExpressions.Regex.IsMatch(Email, emailTest))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "您輸入的電子郵箱帳號格式不正確，請核實後重試！");
                    return;
                }

                if (string.IsNullOrEmpty(_UserBaseBean.Email) || Email.ToLower() != _UserBaseBean.Email.ToLower())
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "您輸入的電子郵箱帳號與輸入的會員名稱註冊時的電子郵箱帳號不匹配或者註冊時未填寫郵箱帳號，請核實後重試！");
                    return;
                }

                if (SnSee.Module.User.User.SendUserPasswordEmail(_EditionBean.ID.Value, _UserBaseBean.ID.Value))
                {
                    litMessage.Text = "密碼已經發送到您的電子郵箱中，請查收！<br />点击这里进行<a href='Login.aspx'>登陸</a>";
                }
                else
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "郵件發送失敗，請重試或聯繫我們！");
                }
            }
            else
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "系統尚未開啟郵件找回密碼功能，請聯繫我們！");
            }
        }
    }
}
