﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Cn_Controls_UserOrderDetailView : System.Web.UI.UserControl
{
    private SnSee.Bean.UserBaseBean _UserBaseBean;
    protected string OrderSn;
    protected string Country;
    protected string Province;
    protected string City;
    protected string ContactPerson;
    protected string Phone;
    protected string Fax;
    protected string Email;
    protected string Company;
    protected string Address;
    protected string PostalCode;
    protected string Message;
    protected string OrderState;

    /// <summary>
    /// 订单ID
    /// </summary>
    private Guid? _OrderBaseID;
    /// <summary>
    /// 订单ID
    /// </summary>
    public Guid? OrderBaseID
    {
        get
        {
            if (Request.QueryString["OrderBaseID"] != null)
            {
                _OrderBaseID = SnSee.Tool.ConvertTool.GetGuid(Request.QueryString["OrderBaseID"]);
            }
            return _OrderBaseID;
        }
        set
        {
            _OrderBaseID = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (SnSee.Module.User.User.UserIsLogin(out _UserBaseBean, true, "Login.aspx?BackUrl=" + SnSee.Tool.EncodeTool.ToBase64CodeString(Request.RawUrl)))
        {
            if (OrderBaseID.HasValue)
            {
                GetOrder(OrderBaseID.Value);
                ProductList_DataBind(OrderBaseID.Value);
            }
        }
    }

    /// <summary>
    /// 取得订单数据
    /// </summary>
    /// <param name="OrderBaseID">订单ID</param>
    private void GetOrder(Guid OrderBaseID)
    {
        SnSee.Bean.OrderBaseBean _OrderBaseBean = (SnSee.Bean.OrderBaseBean)SnSee.Factory.Factory.OrderBase.Select(OrderBaseID);
        if (_OrderBaseBean != null)
        {
            OrderSn = _OrderBaseBean.OrderSn.Value.ToString();
            Country = _OrderBaseBean.Country;
            Province = _OrderBaseBean.Province;
            City = _OrderBaseBean.City;
            ContactPerson = _OrderBaseBean.ContactPerson;
            Phone = _OrderBaseBean.Phone;
            Fax = _OrderBaseBean.Fax;
            Email = _OrderBaseBean.Email;
            Company = _OrderBaseBean.Company;
            Address = _OrderBaseBean.Address;
            PostalCode = _OrderBaseBean.PostalCode;
            Message = _OrderBaseBean.Message;
            if (_OrderBaseBean.State.HasValue)
            {
                OrderState = _OrderBaseBean.State.Value == 1 ? "已處理" : "未處理";
            }
        }
    }

    /// <summary>
    /// 取得订单中产品列表
    /// </summary>
    private void ProductList_DataBind(Guid OrderBaseID)
    {
        ProductList.DataSource = SnSee.Factory.Factory.OrderProduct.SelectList(0, "OrderBaseID='{" + OrderBaseID + "}'", "Order By CreateTime Desc");
        ProductList.DataBind();
    }
}
