﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Cn_Controls_UserOrderEditView : System.Web.UI.UserControl
{
    private SnSee.Bean.UserBaseBean _UserBaseBean = null;

    /// <summary>
    /// 订单ID
    /// </summary>
    private Guid? _OrderBaseID;
    /// <summary>
    /// 订单ID
    /// </summary>
    public Guid? OrderBaseID
    {
        get
        {
            if (Request.QueryString["OrderBaseID"] != null)
            {
                _OrderBaseID = SnSee.Tool.ConvertTool.GetGuid(Request.QueryString["OrderBaseID"]);
            }
            return _OrderBaseID;
        }
        set
        {
            _OrderBaseID = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.User.User.UserIsLogin(out _UserBaseBean, true, "Login.aspx?BackUrl=" + SnSee.Tool.EncodeTool.ToBase64CodeString(Request.RawUrl));
        if (!IsPostBack)
        {
            if (OrderBaseID.HasValue)
            {
                ProductList_DataBind(OrderBaseID.Value);
                GetOrder(OrderBaseID.Value);
            }
            else
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "訂單不存在！", "UserOrderList.aspx");
            }
        }
    }

    /// <summary>
    /// 取得订单中产品列表
    /// </summary>
    private void ProductList_DataBind(Guid OrderBaseID)
    {
        ProductList.DataSource = SnSee.Factory.Factory.OrderProduct.SelectList(0, "OrderBaseID='{" + OrderBaseID + "}'", "Order By CreateTime Desc");
        ProductList.DataBind();
    }

    /// <summary>
    /// 取得订单数据
    /// </summary>
    /// <param name="OrderBaseID">订单ID</param>
    private void GetOrder(Guid OrderBaseID)
    {
        SnSee.Bean.OrderBaseBean _OrderBaseBean = (SnSee.Bean.OrderBaseBean)SnSee.Factory.Factory.OrderBase.Select(OrderBaseID);
        if (_OrderBaseBean != null)
        {
            if (_OrderBaseBean.State.HasValue && _OrderBaseBean.State.Value == 1)
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "訂單狀態爲“已處理”，不能進行修改操作！", "UserOrderDetail.aspx?OrderBaseID=" + OrderBaseID);
            }

            txtCountry.Text = SnSee.Tool.EncodeTool.HtmlDecode(_OrderBaseBean.Country);
            txtProvince.Text = SnSee.Tool.EncodeTool.HtmlDecode(_OrderBaseBean.Province);
            txtCity.Text = SnSee.Tool.EncodeTool.HtmlDecode(_OrderBaseBean.City);
            txtContactPerson.Text = SnSee.Tool.EncodeTool.HtmlDecode(_OrderBaseBean.ContactPerson);
            txtPhone.Text = SnSee.Tool.EncodeTool.HtmlDecode(_OrderBaseBean.Phone);
            txtFax.Text = SnSee.Tool.EncodeTool.HtmlDecode(_OrderBaseBean.Fax);
            txtEmail.Text = SnSee.Tool.EncodeTool.HtmlDecode(_OrderBaseBean.Email);
            txtCompany.Text = SnSee.Tool.EncodeTool.HtmlDecode(_OrderBaseBean.Company);
            txtAddress.Text = SnSee.Tool.EncodeTool.HtmlDecode(_OrderBaseBean.Address);
            txtPostalCode.Text = SnSee.Tool.EncodeTool.HtmlDecode(_OrderBaseBean.PostalCode);
            txtMessage.Text = SnSee.Tool.EncodeTool.HtmlDecode(_OrderBaseBean.Message);
        }
    }

    /// <summary>
    /// 提交
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnPost_Click(object sender, EventArgs e)
    {
        string Country = txtCountry.Text;
        string Province = txtProvince.Text;
        string City = txtCity.Text;
        string ContactPerson = txtContactPerson.Text;
        string Phone = txtPhone.Text;
        string Fax = txtFax.Text;
        string Email = txtEmail.Text;
        string Company = txtCompany.Text;
        string Address = txtAddress.Text;
        string PostalCode = txtPostalCode.Text;
        string Message = txtMessage.Text;

        if (string.IsNullOrEmpty(ContactPerson))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您還未塡寫聯系人！");
            return;
        }
        if (string.IsNullOrEmpty(Phone))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您還未塡寫聯系電話！");
            return;
        }
        SnSee.Bean.OrderBaseBean _OrderBaseBean = new SnSee.Bean.OrderBaseBean();
        _OrderBaseBean.Country = SnSee.Tool.EncodeTool.HtmlEncode(Country);
        _OrderBaseBean.Province = SnSee.Tool.EncodeTool.HtmlEncode(Province);
        _OrderBaseBean.City = SnSee.Tool.EncodeTool.HtmlEncode(City);
        _OrderBaseBean.ContactPerson = SnSee.Tool.EncodeTool.HtmlEncode(ContactPerson);
        _OrderBaseBean.Phone = SnSee.Tool.EncodeTool.HtmlEncode(Phone);
        _OrderBaseBean.Fax = SnSee.Tool.EncodeTool.HtmlEncode(Fax);
        _OrderBaseBean.Email = SnSee.Tool.EncodeTool.HtmlEncode(Email);
        _OrderBaseBean.Company = SnSee.Tool.EncodeTool.HtmlEncode(Company);
        _OrderBaseBean.Address = SnSee.Tool.EncodeTool.HtmlEncode(Address);
        _OrderBaseBean.PostalCode = SnSee.Tool.EncodeTool.HtmlEncode(PostalCode);
        _OrderBaseBean.Message = SnSee.Tool.EncodeTool.HtmlEncode(Message);

        if (SnSee.Factory.Factory.OrderBase.Update(_OrderBaseBean, OrderBaseID.Value))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，訂單編輯成功！", "UserOrderDetail.aspx?OrderBaseID=" + OrderBaseID.Value);
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "訂單編輯失敗，請重試！");
        }
    }
}
