﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Cn_Controls_OrderCartList : System.Web.UI.UserControl
{
    private SnSee.Bean.EditionBean _EditionBean = null;

    /// <summary>
    /// 语言版本标识
    /// </summary>
    private string _EditionKey;
    /// <summary>
    /// 语言版本标识
    /// </summary>
    public string EditionKey
    {
        get
        {
            if (string.IsNullOrEmpty(_EditionKey))
            {
                if (Request.QueryString["EditionKey"] != null)
                {
                    _EditionKey = Request.QueryString["EditionKey"];
                }
                else if (!string.IsNullOrEmpty(SnSee.Config.WebConfig.EditionKey))
                {
                    _EditionKey = SnSee.Config.WebConfig.EditionKey;
                }
            }
            return _EditionKey;
        }
        set
        {
            _EditionKey = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        GetEditionData(EditionKey);
        if (!IsPostBack)
        {
            ProductList_DataBind();
        }
    }

    /// <summary>
    /// 取得语言版本数据
    /// </summary>
    /// <param name="EditionKey">语言版本标识</param>
    private void GetEditionData(string EditionKey)
    {
        if (string.IsNullOrEmpty(EditionKey))
        {
            return;
        }
        _EditionBean = (SnSee.Bean.EditionBean)SnSee.Factory.Factory.Edition.Select("EditionKey='" + EditionKey + "'");
    }

    /// <summary>
    /// 取得购物车中产品列表
    /// </summary>
    private void ProductList_DataBind()
    {
        ProductList.DataSource = SnSee.Module.Order.OrderCart.OrderProductGetList();
        ProductList.DataBind();
    }

    protected void ProductList_ItemDataBound(object source, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            Literal ProductModel = (Literal)e.Item.FindControl("ProductModel");
            Literal ProductName = (Literal)e.Item.FindControl("ProductName");
            Literal ProductPrice = (Literal)e.Item.FindControl("ProductPrice");

            DataRowView drv = (DataRowView)e.Item.DataItem;
            if (drv != null)
            {
                SnSee.Bean.ProductListBean _ProductListBean = null;
                Guid? ProductBaseID = SnSee.Tool.ConvertTool.GetGuid(drv["ProductBaseID"]);
                if (ProductBaseID.HasValue && _EditionBean != null)
                {
                    _ProductListBean = (SnSee.Bean.ProductListBean)SnSee.Factory.Factory.ProductList.Select("ProductBaseID='{" + ProductBaseID.Value + "}' And EditionID='{" + _EditionBean.ID.Value + "}'");
                }

                if (_ProductListBean != null && ProductName != null)
                {
                    if (ProductName != null)
                    {
                        ProductName.Text = _ProductListBean.Name;
                    }
                    if (ProductModel != null)
                    {
                        ProductModel.Text = _ProductListBean.Model;
                    }
                    if (ProductPrice != null && _ProductListBean.Price.HasValue)
                    {
                        ProductPrice.Text = _ProductListBean.Price.Value.ToString();
                    }
                }
            }
        }
    }

    protected void ProductList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            Guid? ProductBaseID = SnSee.Tool.ConvertTool.GetGuid(e.CommandArgument);
            if (ProductBaseID.HasValue)
            {
                SnSee.Module.Order.OrderCart.OrderProductClear(ProductBaseID.Value);
                Response.Redirect(Request.RawUrl);
            }
        }
    }

    /// <summary>
    /// 更新
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnUpdata_Click(object sender, EventArgs e)
    {
        string IDList = "";
        Literal ProductBaseID = null;
        TextBox ProductQuantity = null;

        for (int i = 0; i < ProductList.Items.Count; i++)
        {
            ProductBaseID = (Literal)ProductList.Items[i].FindControl("ProductBaseID");
            ProductQuantity = (TextBox)ProductList.Items[i].FindControl("ProductQuantity");

            if (ProductBaseID != null && !string.IsNullOrEmpty(ProductBaseID.Text) && ProductQuantity != null && !string.IsNullOrEmpty(ProductQuantity.Text))
            {
                IDList += ProductBaseID.Text + "," + ProductQuantity.Text + "|";
            }
        } 
        SnSee.Module.Order.OrderCart.OrderProductSetCookie(IDList);
    }

    /// <summary>
    /// 继续
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnContinue_Click(object sender, EventArgs e)
    {
        Response.Redirect("Product.aspx");
    }

    /// <summary>
    /// 清空
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnClear_Click(object sender, EventArgs e)
    {
        SnSee.Module.Order.OrderCart.OrderProductClear();
        Response.Redirect(Request.RawUrl);
    }

    /// <summary>
    /// 提交
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        Response.Redirect("OrderCartSubmit.aspx");
    }
}
