﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;

public partial class Cn_Controls_ProductClassMenu : System.Web.UI.UserControl
{
    /// <summary>
    /// 语言版本标识
    /// </summary>
    private string _EditionKey;
    /// <summary>
    /// 语言版本标识
    /// </summary>
    public string EditionKey
    {
        get
        {
            if (string.IsNullOrEmpty(_EditionKey))
            {
                if (Request.QueryString["EditionKey"] != null)
                {
                    _EditionKey = Request.QueryString["EditionKey"];
                }
                else if (!string.IsNullOrEmpty(SnSee.Config.WebConfig.EditionKey))
                {
                    _EditionKey = SnSee.Config.WebConfig.EditionKey;
                }
            }
            return _EditionKey;
        }
        set
        {
            _EditionKey = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        EditionBean _EditionBean = null;
        if (!string.IsNullOrEmpty(EditionKey))
        {
            _EditionBean = (EditionBean)SnSee.Factory.Factory.Edition.Select("EditionKey='" + EditionKey + "' And State=1");
            if (_EditionBean != null)
            {
                MenuList.Dispose();
                InitTree(MenuList.Nodes, "(ParentID='' Or ParentID Is Null) And State=1 And IsMenuView=-1 And EditionID='{" + _EditionBean.ID.Value + "}'");
            }
        }
    }

    protected void InitTree(TreeNodeCollection Nds, string Where)//用递归方法动态生成节点
    {
        TreeNode tmpNode;
        List<object> _ProductClassList = SnSee.Factory.Factory.ProductClass.SelectList(0, Where, "Order By SortOrder Asc, CreateTime Asc");
        if (_ProductClassList != null && _ProductClassList.Count > 0)
        {
            ProductClassBean _ProductClassBean = null;
            for (int i = 0; i < _ProductClassList.Count; i++)
            {
                _ProductClassBean = (ProductClassBean)_ProductClassList[i];
                tmpNode = new TreeNode();
                tmpNode.Value = _ProductClassBean.ID.Value.ToString();
                tmpNode.Text = _ProductClassBean.ClassName;
                tmpNode.NavigateUrl = "/Cn/Product.aspx?ProductClassID=" + _ProductClassBean.ID.Value;
                Nds.Add(tmpNode);

                InitTree(tmpNode.ChildNodes, "ParentID='{" + _ProductClassBean.ID.Value + "}'and State=1");
            }
        }
    }
}
