﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;

public partial class Cn_Controls_ProductPicList : System.Web.UI.UserControl
{
    /// <summary>
    /// 产品ID
    /// </summary>
    private Guid? _ProductBaseID;
    /// <summary>
    /// 产品ID
    /// </summary>
    public Guid? ProductBaseID
    {
        get
        {
            if (Request.QueryString["ProductBaseID"] != null)
            {
                _ProductBaseID = SnSee.Tool.ConvertTool.GetGuid(Request.QueryString["ProductBaseID"]);
            }
            return _ProductBaseID;
        }
        set
        {
            _ProductBaseID = value;
        }
    }

    /// <summary>
    /// 产品图片分类标识符
    /// </summary>
    private string _ProductPicClassKey;
    /// <summary>
    /// 产品图片分类标识符
    /// </summary>
    public string ProductPicClassKey
    {
        get
        {
            if (Request.QueryString["ProductPicClassKey"] != null)
            {
                _ProductPicClassKey = Request.QueryString["ProductPicClassKey"];
            }
            return _ProductPicClassKey;
        }
        set
        {
            _ProductPicClassKey = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (ProductBaseID.HasValue && !string.IsNullOrEmpty(ProductPicClassKey))
        {//如果存在产品ID及产品图片分类标识符
            ProductPicClassBean _ProductPicClassBean = (ProductPicClassBean)SnSee.Factory.Factory.ProductPicClass.Select("ClassKey='" + ProductPicClassKey + "'");
            if (_ProductPicClassBean == null)
            {
                return;
            }
            ProductPicList_DataBind(1, 20, "ProductPicList.State=1 And ProductPicList.ProductBaseID='{" + ProductBaseID.Value + "}' And ProductPicList.ProductPicClassID='{" + _ProductPicClassBean.ID.Value + "}'", "Order By ProductPicList.SortOrder Asc, ProductPicList.CreateTime Desc");
        }
    }

    /// <summary>
    /// 取得产品图片列表
    /// </summary>
    /// <param name="_PageIndex">当前页码</param>
    /// <param name="_PageSize">一页最大条数</param>
    /// <param name="_Where">条件</param>
    /// <param name="_OrderBy">排序方式</param>
    private void ProductPicList_DataBind(int _PageIndex, int _PageSize, string _Where, string _OrderBy)
    {
        int _RowCount = 0;
        ProductPicList.DataSource = SnSee.Factory.Factory.ProductPicBase.GetProductPicListPage(_PageIndex, _PageSize, _Where, _OrderBy, out _RowCount);
        ProductPicList.DataBind();
    }
}
