﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;

public partial class Cn_Controls_SalesMenu : System.Web.UI.UserControl
{
    /// <summary>
    /// 语言版本标识
    /// </summary>
    private string _EditionKey;
    /// <summary>
    /// 语言版本标识
    /// </summary>
    public string EditionKey
    {
        get
        {
            if (string.IsNullOrEmpty(_EditionKey))
            {
                if (Request.QueryString["EditionKey"] != null)
                {
                    _EditionKey = Request.QueryString["EditionKey"];
                }
                else if (!string.IsNullOrEmpty(SnSee.Config.WebConfig.EditionKey))
                {
                    _EditionKey = SnSee.Config.WebConfig.EditionKey;
                }
            }
            return _EditionKey;
        }
        set
        {
            _EditionKey = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        EditionBean _EditionBean = null;
        if (!string.IsNullOrEmpty(EditionKey))
        {
            _EditionBean = (EditionBean)SnSee.Factory.Factory.Edition.Select("EditionKey='" + EditionKey + "' And State=1");
            if (_EditionBean != null)
            {
                MenuList.Dispose();
                InitTree(MenuList.Nodes, "(ParentID='' Or ParentID Is Null) And State=1 And EditionID='{" + _EditionBean.ID.Value + "}'");
            }
        }
    }

    protected void InitTree(TreeNodeCollection Nds, string Where)//用递归方法动态生成节点
    {
        TreeNode tmpNode;
        List<object> _SalesClassList = SnSee.Factory.Factory.SalesClass.SelectList(0, Where, "Order By SortOrder Asc, CreateTime Asc");
        if (_SalesClassList != null && _SalesClassList.Count > 0)
        {
            SalesClassBean _SalesClassBean = null;
            for (int i = 0; i < _SalesClassList.Count; i++)
            {
                _SalesClassBean = (SalesClassBean)_SalesClassList[i];
                tmpNode = new TreeNode();
                tmpNode.Value = _SalesClassBean.ID.Value.ToString();
                tmpNode.Text = _SalesClassBean.ClassName;
                tmpNode.NavigateUrl = "../Sales.aspx?SalesClassID=" + _SalesClassBean.ID.Value;
                Nds.Add(tmpNode);

                InitTree(tmpNode.ChildNodes, "ParentID='{" + _SalesClassBean.ID.Value + "}'and State=1");
            }
        }
    }
}
