﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;

public partial class Cn_Controls_ServicePost : System.Web.UI.UserControl
{
    protected SnSee.Bean.UserBaseBean _UserBaseBean;
    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.User.User.UserIsLogin(out _UserBaseBean, false, null);
        if (!IsPostBack)
        {
            SetProductOrderDateYear();
        }
    }

    private void SetProductOrderDateYear()
    {
        int StartYear = 2009;
        int EndYear = DateTime.Now.Year;

        for (int i = StartYear; i <= EndYear; i++)
        {
            dropProductOrderDateYear.Items.Add(new ListItem(i.ToString(), i.ToString()));
        }
    }

    protected void btnPost_Click(object sender, EventArgs e)
    {
        int? ProductQuantity = SnSee.Tool.ConvertTool.GetInt32(txtProductQuantity.Text);
        DateTime? ProductOrderDate = SnSee.Tool.ConvertTool.GetDateTime(dropProductOrderDateYear.SelectedValue + "-" + dropProductOrderDateMonth.SelectedValue + "-" + dropProductOrderDateDay.SelectedValue);

        if (!ProductQuantity.HasValue)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "产品数量只能输入数字，请检查后重试！");
            return;
        }
        if (!ProductOrderDate.HasValue)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "产品购买日期未选填，请检查后重试！");
            return;
        }

        ServiceOrderBean _ServiceOrderBean = new ServiceOrderBean();
        _ServiceOrderBean.UserName = SnSee.Tool.EncodeTool.HtmlEncode(txtUserName.Text);
        _ServiceOrderBean.Gender = SnSee.Tool.ConvertTool.GetInt32(rbtnGender.SelectedValue);
        _ServiceOrderBean.Age = SnSee.Tool.EncodeTool.HtmlEncode(txtAge.Text);
        _ServiceOrderBean.Telephone = SnSee.Tool.EncodeTool.HtmlEncode(txtTelephone.Text);
        _ServiceOrderBean.Mobile = SnSee.Tool.EncodeTool.HtmlEncode(txtMobile.Text);
        _ServiceOrderBean.Fax = SnSee.Tool.EncodeTool.HtmlEncode(txtFax.Text);
        _ServiceOrderBean.Address = SnSee.Tool.EncodeTool.HtmlEncode(txtAddress.Text);
        _ServiceOrderBean.Email = SnSee.Tool.EncodeTool.HtmlEncode(txtEmail.Text);
        _ServiceOrderBean.PostalCode = SnSee.Tool.EncodeTool.HtmlEncode(txtPostalCode.Text);
        _ServiceOrderBean.ProductName = SnSee.Tool.EncodeTool.HtmlEncode(txtProductName.Text);
        _ServiceOrderBean.ProductModel = SnSee.Tool.EncodeTool.HtmlEncode(txtProductModel.Text);
        _ServiceOrderBean.ProductColor = SnSee.Tool.EncodeTool.HtmlEncode(txtProductColor.Text);
        _ServiceOrderBean.ProductSize = SnSee.Tool.EncodeTool.HtmlEncode(txtProductSize.Text);
        _ServiceOrderBean.ProductQuantity = ProductQuantity;
        _ServiceOrderBean.ProductOrderDate = ProductOrderDate;
        _ServiceOrderBean.ProductSeller = SnSee.Tool.EncodeTool.HtmlEncode(txtProductSeller.Text);
        _ServiceOrderBean.ProductOrder = SnSee.Tool.EncodeTool.HtmlEncode(txtProductOrder.Text);
        if (_UserBaseBean != null)
        {
            _ServiceOrderBean.UserBaseID = _UserBaseBean.ID;
        }

        if (SnSee.Factory.Factory.ServiceOrder.Insert(_ServiceOrderBean))
        {
            if (_UserBaseBean != null)
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，提交成功！", "UserProduct.aspx");
            }
            else
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，提交成功！", Request.RawUrl);
            }
        }
    }
}
