﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Cn_Controls_UserCenterView : System.Web.UI.UserControl
{
    private SnSee.Bean.UserBaseBean _UserBaseBean;
    protected string UserName;
    protected string UserLevelName;
    protected string FullName;
    protected string Gender;
    protected string CompanyName;
    protected string Email;
    protected string Tel;
    protected string Fax;
    protected string Address;

    protected string ProductUserName;
    protected string ProductGender;
    protected string ProductAge;
    protected string ProductTelephone;
    protected string ProductMobile;
    protected string ProductFax;
    protected string ProductAddress;
    protected string ProductEmail;
    protected string ProductPostalCode;
    protected string ProductName;
    protected string ProductModel;
    protected string ProductColor;
    protected string ProductSize;
    protected string ProductQuantity;
    protected string ProductOrderDate;
    protected string ProductSeller;
    protected string ProductOrder;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (SnSee.Module.User.User.UserIsLogin(out _UserBaseBean, true, "Login.aspx?BackUrl=" + SnSee.Tool.EncodeTool.ToBase64CodeString(Request.RawUrl)))
        {
            GetUser(_UserBaseBean);
            FeedbackList_DataBind(3, "UserBaseID='{" + _UserBaseBean.ID.Value + "}' And State=1", "Order By CreateTime Desc");  //取得用户信息反馈列表
            OrderList_DataBind(3, "UserBaseID='{" + _UserBaseBean.ID.Value + "}' ", "Order By CreateTime desc");    //取得用户订单列表
            GetUserProduct(_UserBaseBean.ID.Value);
        }
    }

    /// <summary>
    /// 处理用户数据
    /// </summary>
    /// <param name="_UserBaseBean">用户实体数据</param>
    private void GetUser(SnSee.Bean.UserBaseBean _UserBaseBean)
    {
        if (_UserBaseBean == null)
        {
            return;
        }
        UserName = _UserBaseBean.UserName;
        if (_UserBaseBean.UserLevelID.HasValue)
        {
            SnSee.Bean.UserLevelBean _UserLevelBean = (SnSee.Bean.UserLevelBean)SnSee.Factory.Factory.UserLevel.Select(_UserBaseBean.UserLevelID.Value);
            if (_UserLevelBean != null)
            {
                UserLevelName = _UserLevelBean.LevelName;
            }
        }
        FullName = _UserBaseBean.FullName;
        if (_UserBaseBean.Gender.HasValue)
        {
            Gender = _UserBaseBean.Gender.Value == 1 ? "女" : "男";
        }
        CompanyName = _UserBaseBean.CompanyName;
        Email = _UserBaseBean.Email;
        Tel = _UserBaseBean.Tel;
        Fax = _UserBaseBean.Fax;
        Address = _UserBaseBean.Address;
    }

    /// <summary>
    /// 取得用户信息反馈列表数据
    /// </summary>
    /// <param name="_MaxNum">最大条数,0为不限</param>
    /// <param name="_Where">查询条件</param>
    /// <param name="_OrderBy">排序</param>
    private void FeedbackList_DataBind(int _MaxNum, string _Where, string _OrderBy)
    {
        FeedbackList.DataSource = SnSee.Factory.Factory.FeedbackBase.SelectList(_MaxNum, _Where, _OrderBy);
        FeedbackList.DataBind();
    }

    protected void FeedbackList_ItemDataBound(object source, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            Label lblFeedbackRevert = (Label)e.Item.FindControl("lblFeedbackRevert"); SnSee.Bean.FeedbackBaseBean _FeedbackBaseBean = (SnSee.Bean.FeedbackBaseBean)e.Item.DataItem;
            if (_FeedbackBaseBean == null)
            {
                return;
            }

            if (lblFeedbackRevert != null)
            {
                SnSee.Bean.FeedbackRevertBean _FeedbackRevertBean = (SnSee.Bean.FeedbackRevertBean)SnSee.Factory.Factory.FeedbackRevert.Select("FeedbackBaseID='{" + _FeedbackBaseBean.ID.Value + "}'");
                if (_FeedbackRevertBean != null)
                {
                    lblFeedbackRevert.Text = SnSee.Tool.StringTool.CutString(_FeedbackRevertBean.Body, 20, true);
                    lblFeedbackRevert.ToolTip = _FeedbackRevertBean.Body;
                }
                else
                {
                    lblFeedbackRevert.Text = "未回复";
                }
            }
        }
    }

    /// <summary>
    /// 取得用户订单列表数据
    /// </summary>
    /// <param name="_MaxNum">最大条数,0为不限</param>
    /// <param name="_Where">查询条件</param>
    /// <param name="_OrderBy">排序</param>
    private void OrderList_DataBind(int _MaxNum, string _Where, string _OrderBy)
    {
        OrderList.DataSource = SnSee.Factory.Factory.OrderBase.SelectList(_MaxNum, _Where, _OrderBy);
        OrderList.DataBind();
    }

    protected void OrderList_ItemDataBound(object source, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            Repeater ProductList = (Repeater)e.Item.FindControl("ProductList"); SnSee.Bean.OrderBaseBean _OrderBaseBean = (SnSee.Bean.OrderBaseBean)e.Item.DataItem;
            if (_OrderBaseBean == null)
            {
                return;
            }

            if (ProductList != null)
            {
                ProductList.DataSource = SnSee.Factory.Factory.OrderProduct.SelectList(0, "OrderBaseID='{" + _OrderBaseBean.ID.Value + "}'", "Order By CreateTime Desc");
                ProductList.DataBind();
            }
        }
    }

    /// <summary>
    /// 取得用户保用书数据
    /// </summary>
    /// <param name="UserBaseID">用户ID</param>
    private void GetUserProduct(Guid UserBaseID)
    {
        SnSee.Bean.ServiceOrderBean _ServiceOrderBean = (SnSee.Bean.ServiceOrderBean)SnSee.Factory.Factory.ServiceOrder.Select("UserBaseID='{" + UserBaseID + "}'");
        if (_ServiceOrderBean != null)
        {
            ProductUserName = _ServiceOrderBean.UserName;
            if (_ServiceOrderBean.Gender.HasValue)
            {
                ProductGender = _ServiceOrderBean.Gender.Value == 1 ? "女" : "男";
            }
            ProductAge = _ServiceOrderBean.Age;
            ProductTelephone = _ServiceOrderBean.Telephone;
            ProductMobile = _ServiceOrderBean.Mobile;
            ProductFax = _ServiceOrderBean.Fax;
            ProductAddress = _ServiceOrderBean.Address;
            ProductEmail = _ServiceOrderBean.Email;
            ProductPostalCode = _ServiceOrderBean.PostalCode;

            ProductName = _ServiceOrderBean.ProductName;
            ProductModel = _ServiceOrderBean.ProductModel;
            ProductColor = _ServiceOrderBean.ProductColor;
            ProductSize = _ServiceOrderBean.ProductSize;
            if (_ServiceOrderBean.ProductQuantity.HasValue)
            {
                ProductQuantity = _ServiceOrderBean.ProductQuantity.Value.ToString("yyyy-MM-dd");
            }
            if (_ServiceOrderBean.ProductOrderDate.HasValue)
            {
                ProductOrderDate = _ServiceOrderBean.ProductOrderDate.Value.ToString("yyyy-MM-dd");
            }
            ProductSeller = _ServiceOrderBean.ProductSeller;
            ProductOrder = _ServiceOrderBean.ProductOrder;
        }
    }
}
