﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Cn_Controls_UserFeedbackListView : System.Web.UI.UserControl
{
    private SnSee.Bean.UserBaseBean _UserBaseBean;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (SnSee.Module.User.User.UserIsLogin(out _UserBaseBean, true, "Login.aspx?BackUrl=" + SnSee.Tool.EncodeTool.ToBase64CodeString(Request.RawUrl)))
        {
            FeedbackList_DataBind(WebPage1.PageIndex, WebPage1.PageSize, "UserBaseID='{" + _UserBaseBean.ID.Value + "}' And State=1", "Order By CreateTime Desc");
        }
    }

    /// <summary>
    /// 取得用户信息馈列表数据
    /// </summary>
    /// <param name="_PageIndex">当前页索引</param>
    /// <param name="_PageSize">页大小</param>
    /// <param name="_Where">查询条件</param>
    /// <param name="_OrderBy">排序</param>
    private void FeedbackList_DataBind(int _PageIndex, int _PageSize, string _Where, string _OrderBy)
    {
        int RowCount = 0;
        FeedbackList.DataSource = SnSee.Factory.Factory.FeedbackBase.SelectList(_PageIndex, _PageSize, _Where, _OrderBy, out RowCount);
        FeedbackList.DataBind();
        WebPage1.RecordCount = RowCount;
    }

    protected void FeedbackList_ItemDataBound(object source, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            Label lblFeedbackRevert = (Label)e.Item.FindControl("lblFeedbackRevert"); SnSee.Bean.FeedbackBaseBean _FeedbackBaseBean = (SnSee.Bean.FeedbackBaseBean)e.Item.DataItem;
            if (_FeedbackBaseBean == null)
            {
                return;
            }

            if (lblFeedbackRevert != null)
            {
                SnSee.Bean.FeedbackRevertBean _FeedbackRevertBean = (SnSee.Bean.FeedbackRevertBean)SnSee.Factory.Factory.FeedbackRevert.Select("FeedbackBaseID='{" + _FeedbackBaseBean.ID.Value + "}'");
                if (_FeedbackRevertBean != null)
                {
                    lblFeedbackRevert.Text = SnSee.Tool.StringTool.CutString(_FeedbackRevertBean.Body, 20, true);
                    lblFeedbackRevert.ToolTip = _FeedbackRevertBean.Body;
                }
                else
                {
                    lblFeedbackRevert.Text = "未回复";
                }
            }
        }
    }
}
