﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class CN_Controls_UserGetPasswordView : System.Web.UI.UserControl
{
    SnSee.Bean.EditionBean _EditionBean;

    /// <summary>
    /// 语言版本标识
    /// </summary>
    private string _EditionKey;
    /// <summary>
    /// 语言版本标识
    /// </summary>
    public string EditionKey
    {
        get
        {
            if (string.IsNullOrEmpty(_EditionKey))
            {
                if (Request.QueryString["EditionKey"] != null)
                {
                    _EditionKey = Request.QueryString["EditionKey"];
                }
                else if (!string.IsNullOrEmpty(SnSee.Config.WebConfig.EditionKey))
                {
                    _EditionKey = SnSee.Config.WebConfig.EditionKey;
                }
            }
            return _EditionKey;
        }
        set
        {
            _EditionKey = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!string.IsNullOrEmpty(EditionKey))
        {
            _EditionBean = (SnSee.Bean.EditionBean)SnSee.Factory.Factory.Edition.Select("EditionKey='" + EditionKey + "' And State=1");
        }
    }

    /// <summary>
    /// 检查
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCheckUserName_Click(object sender, EventArgs e)
    {
        string UserName = txtUserName.Text;
        if (string.IsNullOrEmpty(UserName))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未输入会员名称！");
            return;
        }

        UserName = SnSee.Tool.StringTool.FilterString(UserName);//过滤恶意字符
        SnSee.Bean.UserBaseBean _UserBaseBean = (SnSee.Bean.UserBaseBean)SnSee.Factory.Factory.UserBase.Select("UserName='" + UserName + "'");
        if (_UserBaseBean == null)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您输入的会员名称不存在！");
            return;
        }
        if (string.IsNullOrEmpty(_UserBaseBean.PasswordQuestion))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您输入的会员名称没有设置密码问题！");
            return;
        }

        txtUserName.ReadOnly = true;
        litPasswordQuestion.Text = _UserBaseBean.PasswordQuestion;
    }

    /// <summary>
    /// 下一步
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnNext_Click(object sender, EventArgs e)
    {
        if (_EditionBean == null)
        {
            return;
        }

        if (rbtnType.Checked)
        {
            string UserName = txtUserName.Text;
            string PasswordAnswer = txtPasswordAnswer.Text;

            if (string.IsNullOrEmpty(UserName))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未输入会员名称！");
                return;
            }

            UserName = SnSee.Tool.StringTool.FilterString(UserName);//过滤恶意字符
            SnSee.Bean.UserBaseBean _UserBaseBean = (SnSee.Bean.UserBaseBean)SnSee.Factory.Factory.UserBase.Select("UserName='" + UserName + "'");
            if (_UserBaseBean == null)
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "您输入的会员名称不存在！");
                return;
            }
            if (string.IsNullOrEmpty(_UserBaseBean.PasswordQuestion))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "您输入的会员名称没有设置密码问题！");
                return;
            }
            if (string.IsNullOrEmpty(PasswordAnswer))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未输入密码问题答案！");
                return;
            }

            if (_UserBaseBean.PasswordAnswer == PasswordAnswer)
            {
                litMessage.Text = "恭喜您，密码找回成功，您的密码是：" + SnSee.Module.User.User.GetUserPassword(_UserBaseBean.UserPwd);
            }
            else
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "密码问题与密码答案不匹配，请核实后重试！");
                return;
            }
        }
        else if (rbtnType2.Checked)
        {
            if (SnSee.Config.EmailConfig.PasswordOpen)
            {
                string UserName = txtUserName2.Text;
                string Email = txtEmail.Text;

                if (string.IsNullOrEmpty(UserName))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未输入会员名称！");
                    return;
                }

                UserName = SnSee.Tool.StringTool.FilterString(UserName);//过滤恶意字符
                SnSee.Bean.UserBaseBean _UserBaseBean = (SnSee.Bean.UserBaseBean)SnSee.Factory.Factory.UserBase.Select("UserName='" + UserName + "'");
                if (_UserBaseBean == null)
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "您输入的会员名称不存在！");
                    return;
                }

                if (string.IsNullOrEmpty(Email))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未输入电子邮箱地址！");
                    return;
                }

                string emailTest = @"\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*";
                if (!System.Text.RegularExpressions.Regex.IsMatch(Email, emailTest))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "您输入的电子邮箱帐号格式不正确，请核实后重试！");
                    return;
                }

                if (string.IsNullOrEmpty(_UserBaseBean.Email) || Email.ToLower() != _UserBaseBean.Email.ToLower())
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "您输入的电子邮箱帐号与输入的会员名称注册时的电子邮箱帐号不匹配或者注册时未填写邮箱帐号，请核实后重试！");
                    return;
                }

                if (SnSee.Module.User.User.SendUserPasswordEmail(_EditionBean.ID.Value, _UserBaseBean.ID.Value))
                {
                    litMessage.Text = "密码已经发送到您的电子邮箱中，请查收！<br />点击这里进行<a href='Login.aspx'>登陆</a>";
                }
                else
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "邮件发送失败，请重试或联系我们！");
                }
            }
            else
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "系统尚未开启邮件找回密码功能，请联系我们！");
            }
        }
    }
}
