﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Cn_Controls_UserOrderListView : System.Web.UI.UserControl
{
    private SnSee.Bean.UserBaseBean _UserBaseBean;
    protected void Page_Load(object sender, EventArgs e)
    {
        if (SnSee.Module.User.User.UserIsLogin(out _UserBaseBean, true, "Login.aspx?BackUrl=" + SnSee.Tool.EncodeTool.ToBase64CodeString(Request.RawUrl)))
        {
            OrderList_DataBind(WebPage1.PageIndex, WebPage1.PageSize, "UserBaseID='{" + _UserBaseBean.ID.Value + "}' ", "Order By CreateTime desc");    //取得用户订单列表
        }
    }

    /// <summary>
    /// 取得用户订单列表数据
    /// </summary>
    /// <param name="_PageIndex">当前页</param>
    /// <param name="_PageSize">页大小</param>
    /// <param name="_Where">查询条件</param>
    /// <param name="_OrderBy">排序</param>
    private void OrderList_DataBind(int _PageIndex, int _PageSize, string _Where, string _OrderBy)
    {
        int RowCount = 0;
        OrderList.DataSource = SnSee.Factory.Factory.OrderBase.SelectList(_PageIndex, _PageSize, _Where, _OrderBy, out RowCount);
        OrderList.DataBind();
        WebPage1.RecordCount = RowCount;
    }

    protected void OrderList_ItemDataBound(object source, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            Repeater ProductList = (Repeater)e.Item.FindControl("ProductList"); SnSee.Bean.OrderBaseBean _OrderBaseBean = (SnSee.Bean.OrderBaseBean)e.Item.DataItem;
            if (_OrderBaseBean == null)
            {
                return;
            }

            if (ProductList != null)
            {
                ProductList.DataSource = SnSee.Factory.Factory.OrderProduct.SelectList(0, "OrderBaseID='{" + _OrderBaseBean.ID.Value + "}'", "Order By CreateTime Desc");
                ProductList.DataBind();
            }
        }
    }
}
