﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Cn_Controls_UserPasswordPost : System.Web.UI.UserControl
{
    private SnSee.Bean.UserBaseBean _UserBaseBean;
    protected string UserName;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (SnSee.Module.User.User.UserIsLogin(out _UserBaseBean, true, "Login.aspx?BackUrl=" + SnSee.Tool.EncodeTool.ToBase64CodeString(Request.RawUrl)))
        {
            if (!IsPostBack)
            {
                GetUser(_UserBaseBean);
            }
        }
    }

    /// <summary>
    /// 处理用户数据
    /// </summary>
    /// <param name="_UserBaseBean">用户实体数据</param>
    private void GetUser(SnSee.Bean.UserBaseBean _UserBaseBean)
    {
        if (_UserBaseBean == null)
        {
            return;
        }
        UserName = _UserBaseBean.UserName;
    }

    /// <summary>
    /// 提交修改
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnPost_Click(object sender, EventArgs e)
    {
        if (_UserBaseBean == null)
        {
            return;
        }

        string UserPwd = txtUserPwd.Text;
        string NewUserPwd = txtNewUserPwd.Text;
        string NewUserPwd2 = txtNewUserPwd2.Text;

        if (string.IsNullOrEmpty(UserPwd))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "请输入您的原会员登陆密码！");
            return;
        }

        if (string.IsNullOrEmpty(NewUserPwd) || string.IsNullOrEmpty(NewUserPwd2))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "新密码或确认新密码没有输入,请核对！");
            return;
        }

        if (NewUserPwd != NewUserPwd2)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "两次输入的新密码不一致，请核对！");
            return;
        }

        if (SnSee.Module.User.User.SetUserPassword(UserPwd) != _UserBaseBean.UserPwd)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "原会员登陆密码不正确，请核对！");
            return;
        } 
        SnSee.Bean.UserBaseBean _UserBaseBeanUp = new SnSee.Bean.UserBaseBean();
        _UserBaseBeanUp.UserPwd = SnSee.Module.User.User.SetUserPassword(NewUserPwd);

        if (SnSee.Factory.Factory.UserBase.Update(_UserBaseBeanUp, _UserBaseBean.ID.Value))
        {
            SnSee.Module.User.User.UserLogout(); SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，密码修改成功，请重新登陆！", "Login.aspx");
        }
    }
}
