﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Cn_Controls_UserProductList : System.Web.UI.UserControl
{
    private SnSee.Bean.UserBaseBean _UserBaseBean;
    protected void Page_Load(object sender, EventArgs e)
    {
        if (SnSee.Module.User.User.UserIsLogin(out _UserBaseBean, true, "Login.aspx?BackUrl=" + SnSee.Tool.EncodeTool.ToBase64CodeString(Request.RawUrl)))
        {
            UserProductList_DataBind(WebPage1.PageIndex, WebPage1.PageSize, "UserBaseID='{" + _UserBaseBean.ID.Value + "}' ", "Order By CreateTime desc");    //取得用户订单列表
        }
    }

    /// <summary>
    /// 取得用户保用书列表数据
    /// </summary>
    /// <param name="_PageIndex">当前页</param>
    /// <param name="_PageSize">页大小</param>
    /// <param name="_Where">查询条件</param>
    /// <param name="_OrderBy">排序</param>
    private void UserProductList_DataBind(int _PageIndex, int _PageSize, string _Where, string _OrderBy)
    {
        int RowCount = 0;
        UserProductList.DataSource = SnSee.Factory.Factory.ServiceOrder.SelectList(_PageIndex, _PageSize, _Where, _OrderBy, out RowCount);
        UserProductList.DataBind();
        WebPage1.RecordCount = RowCount;
    }
}
