﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Default : System.Web.UI.Page
{
    /// <summary>
    /// 语言版本标识
    /// </summary>
    private string _EditionKey;
    /// <summary>
    /// 语言版本标识
    /// </summary>
    public string EditionKey
    {
        get
        {
            if (string.IsNullOrEmpty(_EditionKey))
            {
                if (Request.QueryString["EditionKey"] != null)
                {
                    _EditionKey = Request.QueryString["EditionKey"];
                }
                else if (!string.IsNullOrEmpty(SnSee.Config.WebConfig.EditionKey))
                {
                    _EditionKey = SnSee.Config.WebConfig.EditionKey;
                }
            }
            return _EditionKey;
        }
        set
        {
            _EditionKey = value;
        }
    }


    protected void Page_Load(object sender, EventArgs e)
    {
        if (!string.IsNullOrEmpty(EditionKey))
        {
            //取得语言版本数据
            SnSee.Bean.EditionBean _EditionBean = (SnSee.Bean.EditionBean)SnSee.Factory.Factory.Edition.Select("EditionKey='" + EditionKey + "' And State=1");
            if (_EditionBean != null)
            {//如果存在语言版本 
                //绑定当前语言版本产品列表
                ProductList_DataBind(1, 12, "ProductList.State=1 And ProductList.EditionID='{" + _EditionBean.ID.Value + "}'", "Order By ProductList.SortOrder Asc, ProductList.CreateTime Desc");

                //绑定新闻1数据
                NewsList_DataBind(NewsList1, 1, 6, "ArticleClass.ClassKey='公司新闻' And ArticleBase.State=1", "Order By ArticleBase.SortOrder Asc, ArticleBase.CreateTime Desc");

                //绑定新闻2数据
                NewsList_DataBind(NewsList2, 1, 6, "ArticleClass.ClassKey='行业新闻' And ArticleBase.State=1", "Order By ArticleBase.SortOrder Asc, ArticleBase.CreateTime Desc");
            }
        }
    }

    /// <summary>
    /// 取得产品列表
    /// </summary>
    /// <param name="_PageIndex">当前页码</param>
    /// <param name="_PageSize">一页最大条数</param>
    /// <param name="_Where">条件</param>
    /// <param name="_OrderBy">排序方式</param>
    private void ProductList_DataBind(int _PageIndex, int _PageSize, string _Where, string _OrderBy)
    {
        int _RowCount = 0;
        ProductList.DataSource = SnSee.Factory.Factory.ProductBase.GetProductListPage(_PageIndex, _PageSize, _Where, _OrderBy, out _RowCount);
        ProductList.DataBind();
    }

    /// <summary>
    /// 
    /// </summary>
    /// <param name="_Repeater">数据控件名称</param>
    /// <param name="_PageIndex">当前页码</param>
    /// <param name="_PageSize">一页最大条数</param>
    /// <param name="_Where">条件</param>
    /// <param name="_OrderBy">排序方式</param>
    private void NewsList_DataBind(Repeater _Repeater, int _PageIndex, int _PageSize, string _Where, string _OrderBy)
    {
        int RowCount = 0;
        _Repeater.DataSource = SnSee.Factory.Factory.ArticleBase.GetArticleListPage(_PageIndex, _PageSize, _Where, _OrderBy, out RowCount);
        _Repeater.DataBind();
    }
}
