﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;

public partial class Cn_Controls_ArticleSearch : System.Web.UI.UserControl
{
    /// <summary>
    /// 语言版本标识
    /// </summary>
    private string _EditionKey;
    /// <summary>
    /// 语言版本标识
    /// </summary>
    public string EditionKey
    {
        get
        {
            if (string.IsNullOrEmpty(_EditionKey))
            {
                if (Request.QueryString["EditionKey"] != null)
                {
                    _EditionKey = Request.QueryString["EditionKey"];
                }
                else if (!string.IsNullOrEmpty(SnSee.Config.WebConfig.EditionKey))
                {
                    _EditionKey = SnSee.Config.WebConfig.EditionKey;
                }
            }
            return _EditionKey;
        }
        set
        {
            _EditionKey = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        EditionBean _EditionBean = null;
        if (!string.IsNullOrEmpty(EditionKey))
        {
            _EditionBean = (EditionBean)SnSee.Factory.Factory.Edition.Select("EditionKey='" + EditionKey + "' And State=1");
        }

        if (_EditionBean != null)
        {
            if (!IsPostBack)
            {
                dropArticleClass_DataBind(_EditionBean.ID.Value);
            }
        }
    }

    /// <summary>
    /// 搜索
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSearch_Click(object sender, EventArgs e)
    {
        Response.Redirect("NewsSearch.aspx?ArticleClassID=" + Request[dropArticleClass.UniqueID] + "&Keyword=" + txtKeyword.Text + "&Action=Search");
    }

    /// <summary>
    /// 载入当前语言版本文章分类数据
    /// </summary>
    /// <param name="EditionID">语言版本ID</param>
    private void dropArticleClass_DataBind(Guid EditionID)
    {
        dropArticleClass.DataSource = SnSee.Module.Article.ArticleClassTree.GetClassTreeList(null, "State=1 And EditionID='{" + EditionID + "}'", "Order by SortOrder asc, CreateTime Desc");
        dropArticleClass.DataBind();

        dropArticleClass.Items.Insert(0, new ListItem("All News Class", ""));
    }
}
