﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Cn_Controls_FeedbackPost : System.Web.UI.UserControl
{
    SnSee.Bean.EditionBean _EditionBean; SnSee.Bean.UserBaseBean _UserBaseBean;

    /// <summary>
    /// 语言版本标识
    /// </summary>
    private string _EditionKey;
    /// <summary>
    /// 语言版本标识
    /// </summary>
    public string EditionKey
    {
        get
        {
            if (string.IsNullOrEmpty(_EditionKey))
            {
                if (Request.QueryString["EditionKey"] != null)
                {
                    _EditionKey = Request.QueryString["EditionKey"];
                }
                else if (!string.IsNullOrEmpty(SnSee.Config.WebConfig.EditionKey))
                {
                    _EditionKey = SnSee.Config.WebConfig.EditionKey;
                }
            }
            return _EditionKey;
        }
        set
        {
            _EditionKey = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.User.User.UserIsLogin(out _UserBaseBean, SnSee.Config.FeedbackConfig.LoginPost);
        if (!string.IsNullOrEmpty(EditionKey))
        {
            _EditionBean = (SnSee.Bean.EditionBean)SnSee.Factory.Factory.Edition.Select("EditionKey='" + EditionKey + "' And State=1");
        }
    }

    /// <summary>
    /// 提交
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnPost_Click(object sender, EventArgs e)
    {
        if (SnSee.Config.FeedbackConfig.LoginPost)
        {
            if (_EditionBean == null)
            {//一定要指定语言版本标识(EditionKey属性值要指定值)，才能提交内容
                return;
            }

            string Body = txtBody.Text;
            if (string.IsNullOrEmpty(Body))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "Please enter message！");
            }
            SnSee.Bean.FeedbackBaseBean _FeedbackBaseBean = new SnSee.Bean.FeedbackBaseBean();
            _FeedbackBaseBean.Contact = SnSee.Tool.EncodeTool.HtmlEncode(txtContact.Text);
            _FeedbackBaseBean.CompanyName = SnSee.Tool.EncodeTool.HtmlEncode(txtCompanyName.Text);
            _FeedbackBaseBean.Tel = SnSee.Tool.EncodeTool.HtmlEncode(txtTel.Text);
            _FeedbackBaseBean.Email = SnSee.Tool.EncodeTool.HtmlEncode(txtEmail.Text);
            _FeedbackBaseBean.State = 1;
            _FeedbackBaseBean.Body = SnSee.Tool.EncodeTool.HtmlEncode(Body);
            if (_UserBaseBean != null)
            {
                _FeedbackBaseBean.UserBaseID = _UserBaseBean.ID;
            }
            if (_EditionBean != null)
            {
                _FeedbackBaseBean.EditionID = _EditionBean.ID;
            }

            if (SnSee.Factory.Factory.FeedbackBase.Insert(_FeedbackBaseBean))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "You successfully submit feedback, we will promptly deal with!", Request.RawUrl);
            }
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "Please visit the feedback after the publication of!", "Login.aspx");
        }
    }
}
