﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Cn_Controls_JoinPost : System.Web.UI.UserControl
{
    private SnSee.Bean.EditionBean _EditionBean = null;
    protected SnSee.Bean.UserBaseBean _UserBaseBean;

    /// <summary>
    /// 语言版本标识
    /// </summary>
    private string _EditionKey;
    /// <summary>
    /// 语言版本标识
    /// </summary>
    public string EditionKey
    {
        get
        {
            if (string.IsNullOrEmpty(_EditionKey))
            {
                if (Request.QueryString["EditionKey"] != null)
                {
                    _EditionKey = Request.QueryString["EditionKey"];
                }
                else if (!string.IsNullOrEmpty(SnSee.Config.WebConfig.EditionKey))
                {
                    _EditionKey = SnSee.Config.WebConfig.EditionKey;
                }
            }
            return _EditionKey;
        }
        set
        {
            _EditionKey = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.User.User.UserIsLogin(out _UserBaseBean, false, null);
        GetEditionData(EditionKey);
    }

    /// <summary>
    /// 取得语言版本数据
    /// </summary>
    /// <param name="EditionKey">语言版本标识</param>
    private void GetEditionData(string EditionKey)
    {
        if (string.IsNullOrEmpty(EditionKey))
        {
            return;
        }
        _EditionBean = (SnSee.Bean.EditionBean)SnSee.Factory.Factory.Edition.Select("EditionKey='" + EditionKey + "'");
    }

    protected void btnPost_Click(object sender, EventArgs e)
    {
        SnSee.Bean.JoinBaseBean _JoinBaseBean = new SnSee.Bean.JoinBaseBean();
        _JoinBaseBean.UserName = SnSee.Tool.EncodeTool.HtmlEncode(txtUserName.Text);
        _JoinBaseBean.Gender = SnSee.Tool.ConvertTool.GetInt32(rbtnGender.SelectedValue);
        _JoinBaseBean.Age = SnSee.Tool.EncodeTool.HtmlEncode(txtAge.Text);
        _JoinBaseBean.Telephone = SnSee.Tool.EncodeTool.HtmlEncode(txtTelephone.Text);
        _JoinBaseBean.Mobile = SnSee.Tool.EncodeTool.HtmlEncode(txtMobile.Text);
        _JoinBaseBean.Fax = SnSee.Tool.EncodeTool.HtmlEncode(txtFax.Text);
        _JoinBaseBean.Address = SnSee.Tool.EncodeTool.HtmlEncode(txtAddress.Text);
        _JoinBaseBean.Email = SnSee.Tool.EncodeTool.HtmlEncode(txtEmail.Text);
        _JoinBaseBean.PostalCode = SnSee.Tool.EncodeTool.HtmlEncode(txtPostalCode.Text);
        _JoinBaseBean.ShopAddress = SnSee.Tool.EncodeTool.HtmlEncode(txtShopAddress.Text);
        _JoinBaseBean.ShopAcreage = SnSee.Tool.EncodeTool.HtmlEncode(txtShopAcreage.Text);
        _JoinBaseBean.ShopType = rbtnShopType.SelectedValue;
        _JoinBaseBean.ShopStart = rbtnShopStart.SelectedValue;
        _JoinBaseBean.ShopArea = rbtnShopArea.SelectedValue;
        _JoinBaseBean.ShopOperation = rbtnShopOperation.SelectedValue;
        _JoinBaseBean.ShopMonthSale = SnSee.Tool.EncodeTool.HtmlEncode(txtShopMonthSale.Text);
        _JoinBaseBean.ShopMonthPayoff = SnSee.Tool.EncodeTool.HtmlEncode(txtShopMonthPayoff.Text);
        _JoinBaseBean.ShopJoinOrigin = rbtnShopJoinOrigin.SelectedValue;
        _JoinBaseBean.ShopForecast = SnSee.Tool.EncodeTool.HtmlEncode(txtShopForecast.Text);
        _JoinBaseBean.ShopExpectations = SnSee.Tool.EncodeTool.HtmlEncode(txtShopExpectations.Text);
        _JoinBaseBean.ShopAdvantage = SnSee.Tool.EncodeTool.HtmlEncode(txtShopAdvantage.Text);
        _JoinBaseBean.State = 0;
        if (_EditionBean != null)
        {
            _JoinBaseBean.EditionID = _EditionBean.ID;
        }
        if (_UserBaseBean != null)
        {
            _JoinBaseBean.UserBaseID = _UserBaseBean.ID;
        }

        if (SnSee.Factory.Factory.JoinBase.Insert(_JoinBaseBean))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "Submitted by the successful application to join, please wait for us to deal with, or directly contact us!", Request.RawUrl);
        }
    }
}
