﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Cn_Controls_OrderCartSubmitView : System.Web.UI.UserControl
{
    private SnSee.Bean.EditionBean _EditionBean = null;
    private SnSee.Bean.UserBaseBean _UserBaseBean = null;

    /// <summary>
    /// 语言版本标识
    /// </summary>
    private string _EditionKey;
    /// <summary>
    /// 语言版本标识
    /// </summary>
    public string EditionKey
    {
        get
        {
            if (string.IsNullOrEmpty(_EditionKey))
            {
                if (Request.QueryString["EditionKey"] != null)
                {
                    _EditionKey = Request.QueryString["EditionKey"];
                }
                else if (!string.IsNullOrEmpty(SnSee.Config.WebConfig.EditionKey))
                {
                    _EditionKey = SnSee.Config.WebConfig.EditionKey;
                }
            }
            return _EditionKey;
        }
        set
        {
            _EditionKey = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.User.User.UserIsLogin(out _UserBaseBean, false, null);
        GetEditionData(EditionKey);
        if (!IsPostBack)
        {
            ProductList_DataBind();
        }
    }

    /// <summary>
    /// 取得语言版本数据
    /// </summary>
    /// <param name="EditionKey">语言版本标识</param>
    private void GetEditionData(string EditionKey)
    {
        if (string.IsNullOrEmpty(EditionKey))
        {
            return;
        }
        _EditionBean = (SnSee.Bean.EditionBean)SnSee.Factory.Factory.Edition.Select("EditionKey='" + EditionKey + "'");
    }

    /// <summary>
    /// 取得购物车中产品列表
    /// </summary>
    private void ProductList_DataBind()
    {
        ProductList.DataSource = SnSee.Module.Order.OrderCart.OrderProductGetList();
        ProductList.DataBind();
    }

    protected void ProductList_ItemDataBound(object source, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            Literal ProductModel = (Literal)e.Item.FindControl("ProductModel");
            Literal ProductName = (Literal)e.Item.FindControl("ProductName");
            Literal ProductPrice = (Literal)e.Item.FindControl("ProductPrice");

            DataRowView drv = (DataRowView)e.Item.DataItem;
            if (drv != null)
            {
                SnSee.Bean.ProductListBean _ProductListBean = null;
                Guid? ProductBaseID = SnSee.Tool.ConvertTool.GetGuid(drv["ProductBaseID"]);
                if (ProductBaseID.HasValue && _EditionBean != null)
                {
                    _ProductListBean = (SnSee.Bean.ProductListBean)SnSee.Factory.Factory.ProductList.Select("ProductBaseID='{" + ProductBaseID.Value + "}' And EditionID='{" + _EditionBean.ID.Value + "}'");
                }

                if (_ProductListBean != null && ProductName != null)
                {
                    if (ProductName != null)
                    {
                        ProductName.Text = _ProductListBean.Name;
                    }
                    if (ProductModel != null)
                    {
                        ProductModel.Text = _ProductListBean.Model;
                    }
                    if (ProductPrice != null && _ProductListBean.Price.HasValue)
                    {
                        ProductPrice.Text = _ProductListBean.Price.Value.ToString();
                    }
                }
            }
        }
    }

    protected void ProductList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            Guid? ProductBaseID = SnSee.Tool.ConvertTool.GetGuid(e.CommandArgument);
            if (ProductBaseID.HasValue)
            {
                SnSee.Module.Order.OrderCart.OrderProductClear(ProductBaseID.Value);
                Response.Redirect(Request.RawUrl);
            }
        }
    }

    /// <summary>
    /// 提交
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnPost_Click(object sender, EventArgs e)
    {
        string Country = txtCountry.Text;
        string Province = txtProvince.Text;
        string City = txtCity.Text;
        string ContactPerson = txtContactPerson.Text;
        string Phone = txtPhone.Text;
        string Fax = txtFax.Text;
        string Email = txtEmail.Text;
        string Company = txtCompany.Text;
        string Address = txtAddress.Text;
        string PostalCode = txtPostalCode.Text;
        string Message = txtMessage.Text;

        if (string.IsNullOrEmpty(ContactPerson))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "Contact Person can not be blank!");
            return;
        }
        if (string.IsNullOrEmpty(Phone))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "Tel can not be blank!");
            return;
        }
        SnSee.Bean.OrderBaseBean _OrderBaseBean = new SnSee.Bean.OrderBaseBean();
        _OrderBaseBean.ID = Guid.NewGuid();
        _OrderBaseBean.Country = SnSee.Tool.EncodeTool.HtmlEncode(Country);
        _OrderBaseBean.Province = SnSee.Tool.EncodeTool.HtmlEncode(Province);
        _OrderBaseBean.City = SnSee.Tool.EncodeTool.HtmlEncode(City);
        _OrderBaseBean.ContactPerson = SnSee.Tool.EncodeTool.HtmlEncode(ContactPerson);
        _OrderBaseBean.Phone = SnSee.Tool.EncodeTool.HtmlEncode(Phone);
        _OrderBaseBean.Fax = SnSee.Tool.EncodeTool.HtmlEncode(Fax);
        _OrderBaseBean.Email = SnSee.Tool.EncodeTool.HtmlEncode(Email);
        _OrderBaseBean.Company = SnSee.Tool.EncodeTool.HtmlEncode(Company);
        _OrderBaseBean.Address = SnSee.Tool.EncodeTool.HtmlEncode(Address);
        _OrderBaseBean.PostalCode = SnSee.Tool.EncodeTool.HtmlEncode(PostalCode);
        _OrderBaseBean.Message = SnSee.Tool.EncodeTool.HtmlEncode(Message);
        if (_EditionBean != null)
        {
            _OrderBaseBean.EditionID = _EditionBean.ID;
        }
        if (_UserBaseBean != null)
        {
            _OrderBaseBean.UserBaseID = _UserBaseBean.ID;
        }

        SetOrderProduct(_OrderBaseBean.ID.Value);

        if (SnSee.Factory.Factory.OrderBase.Insert(_OrderBaseBean))
        {
            SnSee.Module.Order.OrderCart.OrderProductClear();
            if (_UserBaseBean != null)
            {//如果用户已登陆 
                SnSee.Tool.MessageTool.MessageBox(this.Page, "Orders submitted successfully, please wait for us to deal with!", "UserOrderDetail.aspx?OrderBaseID=" + _OrderBaseBean.ID.Value);
            }
            else
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "Orders submitted successfully, please wait for us to deal with!", "Product.aspx");
            }
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "Failure to submit orders, please try again!");
        }
    }

    /// <summary>
    /// 设置订单产品数据
    /// </summary>
    /// <param name="OrderBaseID">订单ID</param>
    private void SetOrderProduct(Guid OrderBaseID)
    {
        DataTable dt = SnSee.Module.Order.OrderCart.OrderProductGetList();
        if (dt != null && dt.Rows.Count > 0)
        {
            SnSee.Bean.ProductListBean _ProductListBean = null;
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                Guid? ProductBaseID = SnSee.Tool.ConvertTool.GetGuid(dt.Rows[i]["ProductBaseID"]);
                int? ProductQuantity = SnSee.Tool.ConvertTool.GetInt32(dt.Rows[i]["Quantity"]);
                if (ProductBaseID.HasValue && ProductQuantity.HasValue && _EditionBean != null)
                {
                    _ProductListBean = (SnSee.Bean.ProductListBean)SnSee.Factory.Factory.ProductList.Select("ProductBaseID='{" + ProductBaseID.Value + "}' And EditionID='{" + _EditionBean.ID.Value + "}'");
                    if (_ProductListBean != null)
                    {
                        SnSee.Bean.OrderProductBean _OrderProductBean = new SnSee.Bean.OrderProductBean();
                        _OrderProductBean.OrderBaseID = OrderBaseID;
                        _OrderProductBean.ProductBaseID = ProductBaseID;
                        _OrderProductBean.ProductModel = _ProductListBean.Model;
                        _OrderProductBean.ProductName = _ProductListBean.Name;
                        _OrderProductBean.ProductPrice = _ProductListBean.Price;
                        _OrderProductBean.ProductQuantity = ProductQuantity; SnSee.Factory.Factory.OrderProduct.Insert(_OrderProductBean);
                    }
                }
            }
        }
    }
}
