﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class CN_Controls_UserGetPasswordView : System.Web.UI.UserControl
{
    SnSee.Bean.EditionBean _EditionBean;

    /// <summary>
    /// 语言版本标识
    /// </summary>
    private string _EditionKey;
    /// <summary>
    /// 语言版本标识
    /// </summary>
    public string EditionKey
    {
        get
        {
            if (string.IsNullOrEmpty(_EditionKey))
            {
                if (Request.QueryString["EditionKey"] != null)
                {
                    _EditionKey = Request.QueryString["EditionKey"];
                }
                else if (!string.IsNullOrEmpty(SnSee.Config.WebConfig.EditionKey))
                {
                    _EditionKey = SnSee.Config.WebConfig.EditionKey;
                }
            }
            return _EditionKey;
        }
        set
        {
            _EditionKey = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!string.IsNullOrEmpty(EditionKey))
        {
            _EditionBean = (SnSee.Bean.EditionBean)SnSee.Factory.Factory.Edition.Select("EditionKey='" + EditionKey + "' And State=1");
        }
    }

    /// <summary>
    /// 检查
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCheckUserName_Click(object sender, EventArgs e)
    {
        string UserName = txtUserName.Text;
        if (string.IsNullOrEmpty(UserName))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "Enter the member name you have not yet!");
            return;
        }

        UserName = SnSee.Tool.StringTool.FilterString(UserName);//过滤恶意字符
        SnSee.Bean.UserBaseBean _UserBaseBean = (SnSee.Bean.UserBaseBean)SnSee.Factory.Factory.UserBase.Select("UserName='" + UserName + "'");
        if (_UserBaseBean == null)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "Member name you entered does not exist!");
            return;
        }
        if (string.IsNullOrEmpty(_UserBaseBean.PasswordQuestion))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "Member name you entered is not provided with a password problem!");
            return;
        }

        txtUserName.ReadOnly = true;
        litPasswordQuestion.Text = _UserBaseBean.PasswordQuestion;
    }

    /// <summary>
    /// 下一步
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnNext_Click(object sender, EventArgs e)
    {
        if (_EditionBean == null)
        {
            return;
        }

        if (rbtnType.Checked)
        {
            string UserName = txtUserName.Text;
            string PasswordAnswer = txtPasswordAnswer.Text;

            if (string.IsNullOrEmpty(UserName))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "Enter the member name you have not yet!");
                return;
            }

            UserName = SnSee.Tool.StringTool.FilterString(UserName);//过滤恶意字符
            SnSee.Bean.UserBaseBean _UserBaseBean = (SnSee.Bean.UserBaseBean)SnSee.Factory.Factory.UserBase.Select("UserName='" + UserName + "'");
            if (_UserBaseBean == null)
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "Member name you entered does not exist!");
                return;
            }
            if (string.IsNullOrEmpty(_UserBaseBean.PasswordQuestion))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "Member name you entered is not provided with a password problem!");
                return;
            }
            if (string.IsNullOrEmpty(PasswordAnswer))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "You do not enter a password question answer!");
                return;
            }

            if (_UserBaseBean.PasswordAnswer == PasswordAnswer)
            {
                litMessage.Text = "Congratulations, you successfully recover your password, your password is:" + SnSee.Module.User.User.GetUserPassword(_UserBaseBean.UserPwd);
            }
            else
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "Answer the question of the password and password do not match, please try again later to verify!");
                return;
            }
        }
        else if (rbtnType2.Checked)
        {
            if (SnSee.Config.EmailConfig.PasswordOpen)
            {
                string UserName = txtUserName2.Text;
                string Email = txtEmail.Text;

                if (string.IsNullOrEmpty(UserName))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "Enter the member name you have not yet!");
                    return;
                }

                UserName = SnSee.Tool.StringTool.FilterString(UserName);//过滤恶意字符
                SnSee.Bean.UserBaseBean _UserBaseBean = (SnSee.Bean.UserBaseBean)SnSee.Factory.Factory.UserBase.Select("UserName='" + UserName + "'");
                if (_UserBaseBean == null)
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "Member name you entered does not exist!");
                    return;
                }

                if (string.IsNullOrEmpty(Email))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "You do not enter the e-mail address!");
                    return;
                }

                string emailTest = @"\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*";
                if (!System.Text.RegularExpressions.Regex.IsMatch(Email, emailTest))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "Your e-mail account input format is incorrect, please try again later to verify!");
                    return;
                }

                if (string.IsNullOrEmpty(_UserBaseBean.Email) || Email.ToLower() != _UserBaseBean.Email.ToLower())
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "You enter the e-mail account and enter the name of the registered members of the e-mail account does not match or did not fill in the registration mail account, please try again later to verify!");
                    return;
                }

                if (SnSee.Module.User.User.SendUserPasswordEmail(_EditionBean.ID.Value, _UserBaseBean.ID.Value))
                {
                    litMessage.Text = "Password has been sent to your e-mail, please check!<br /><a href='Login.aspx'>Click here to Login</a>";
                }
                else
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "E-mail failed, please try again or contact us!");
                }
            }
            else
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "System has yet to find a password to open e-mail function, please contact us!");
            }
        }
    }
}
