﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Cn_Controls_UserInfoPost : System.Web.UI.UserControl
{
    private SnSee.Bean.UserBaseBean _UserBaseBean;
    protected string UserName;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (SnSee.Module.User.User.UserIsLogin(out _UserBaseBean, true, "Login.aspx?BackUrl=" + SnSee.Tool.EncodeTool.ToBase64CodeString(Request.RawUrl)))
        {
            if (!IsPostBack)
            {
                GetUser(_UserBaseBean);
            }
        }
    }

    /// <summary>
    /// 处理用户数据
    /// </summary>
    /// <param name="_UserBaseBean">用户实体数据</param>
    private void GetUser(SnSee.Bean.UserBaseBean _UserBaseBean)
    {
        if (_UserBaseBean == null)
        {
            return;
        }
        UserName = _UserBaseBean.UserName;
        txtFullName.Text = _UserBaseBean.FullName;
        if (_UserBaseBean.Gender.HasValue)
        {
            rbtnGender.SelectedValue = _UserBaseBean.Gender.Value.ToString();
        }
        txtCompanyName.Text = SnSee.Tool.EncodeTool.HtmlDecode(_UserBaseBean.CompanyName);
        txtAddress.Text = SnSee.Tool.EncodeTool.HtmlDecode(_UserBaseBean.Address);
        txtTel.Text = SnSee.Tool.EncodeTool.HtmlDecode(_UserBaseBean.Tel);
        txtFax.Text = SnSee.Tool.EncodeTool.HtmlDecode(_UserBaseBean.Fax);
        txtEmail.Text = SnSee.Tool.EncodeTool.HtmlDecode(_UserBaseBean.Email);
        txtPasswordQuestion.Text = _UserBaseBean.PasswordQuestion;
        txtPasswordAnswer.Text = _UserBaseBean.PasswordAnswer;
    }

    /// <summary>
    /// 提交修改
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnPost_Click(object sender, EventArgs e)
    {
        if (_UserBaseBean == null)
        {
            return;
        }
        SnSee.Bean.UserBaseBean _UserBaseBeanUp = new SnSee.Bean.UserBaseBean();
        _UserBaseBeanUp.FullName = SnSee.Tool.EncodeTool.HtmlEncode(txtFullName.Text);
        _UserBaseBeanUp.Gender = SnSee.Tool.ConvertTool.GetInt32(rbtnGender.SelectedValue);
        _UserBaseBeanUp.CompanyName = SnSee.Tool.EncodeTool.HtmlEncode(txtCompanyName.Text);
        _UserBaseBeanUp.Address = SnSee.Tool.EncodeTool.HtmlEncode(txtAddress.Text);
        _UserBaseBeanUp.Tel = SnSee.Tool.EncodeTool.HtmlEncode(txtTel.Text);
        _UserBaseBeanUp.Fax = SnSee.Tool.EncodeTool.HtmlEncode(txtFax.Text);
        _UserBaseBeanUp.Email = SnSee.Tool.EncodeTool.HtmlEncode(txtEmail.Text);
        _UserBaseBeanUp.PasswordQuestion = txtPasswordQuestion.Text;
        _UserBaseBeanUp.PasswordAnswer = txtPasswordAnswer.Text;

        if (SnSee.Factory.Factory.UserBase.Update(_UserBaseBeanUp, _UserBaseBean.ID.Value))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "Update successful!", "UserCenter.aspx");
        }
    }
}
