﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Cn_Controls_UserLogin : System.Web.UI.UserControl
{
    SnSee.Bean.UserBaseBean _UserBaseBean;
    protected string UserName;
    protected string UserLevelName;

    protected void Page_Load(object sender, EventArgs e)
    {
        GetUser();
    }

    /// <summary>
    /// 取得登陆用户数据
    /// </summary>
    private void GetUser()
    {
        if (SnSee.Module.User.User.UserIsLogin(out _UserBaseBean, false, null))
        {
            pnlUserLogin.Visible = false;
            pnlUserLogined.Visible = true;

            UserName = _UserBaseBean.UserName;
            if (_UserBaseBean.UserLevelID.HasValue)
            {
                SnSee.Bean.UserLevelBean _UserLevelBean = (SnSee.Bean.UserLevelBean)SnSee.Factory.Factory.UserLevel.Select(_UserBaseBean.UserLevelID.Value);
                if (_UserLevelBean != null)
                {
                    UserLevelName = _UserLevelBean.LevelName;
                }
            }
        }
        else
        {
            pnlUserLogin.Visible = true;
            pnlUserLogined.Visible = false;
        }
    }

    /// <summary>
    /// 登陆
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnLogin_Click(object sender, EventArgs e)
    {
        string UserName = txtUserName.Text;
        string UserPwd = txtUserPwd.Text;

        if (string.IsNullOrEmpty(UserName) || string.IsNullOrEmpty(UserPwd))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "You do not enter a user name or password!");
            return;
        }

        int Flag = 0;
        //执行登陆
        if (SnSee.Module.User.User.UserLogin(UserName, UserPwd, 720, out Flag))
        {//登陆成功 
            Response.Redirect("UserCenter.aspx");
        }
        else
        {
            switch (Flag)
            {
                case 2:
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "Your user has been banned, please contact us!");
                    break;
                default:
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "Login failed, please check your username and password!");
                    break;
            }
            return;
        }
    }
    protected void btnReg_Click(object sender, EventArgs e)
    {
        Response.Redirect("UserRegister.aspx");
    }
}
