﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Cn_Controls_UserPasswordPost : System.Web.UI.UserControl
{
    private SnSee.Bean.UserBaseBean _UserBaseBean;
    protected string UserName;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (SnSee.Module.User.User.UserIsLogin(out _UserBaseBean, true, "Login.aspx?BackUrl=" + SnSee.Tool.EncodeTool.ToBase64CodeString(Request.RawUrl)))
        {
            if (!IsPostBack)
            {
                GetUser(_UserBaseBean);
            }
        }
    }

    /// <summary>
    /// 处理用户数据
    /// </summary>
    /// <param name="_UserBaseBean">用户实体数据</param>
    private void GetUser(SnSee.Bean.UserBaseBean _UserBaseBean)
    {
        if (_UserBaseBean == null)
        {
            return;
        }
        UserName = _UserBaseBean.UserName;
    }

    /// <summary>
    /// 提交修改
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnPost_Click(object sender, EventArgs e)
    {
        if (_UserBaseBean == null)
        {
            return;
        }

        string UserPwd = txtUserPwd.Text;
        string NewUserPwd = txtNewUserPwd.Text;
        string NewUserPwd2 = txtNewUserPwd2.Text;

        if (string.IsNullOrEmpty(UserPwd))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "Please enter your old password！");
            return;
        }

        if (string.IsNullOrEmpty(NewUserPwd) || string.IsNullOrEmpty(NewUserPwd2))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "Confirm a new password or did not enter a new password, please check!");
            return;
        }

        if (NewUserPwd != NewUserPwd2)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "Enter the new password twice inconsistencies, please check!");
            return;
        }

        if (SnSee.Module.User.User.SetUserPassword(UserPwd) != _UserBaseBean.UserPwd)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "The old password is incorrect, please check!");
            return;
        } 
        SnSee.Bean.UserBaseBean _UserBaseBeanUp = new SnSee.Bean.UserBaseBean();
        _UserBaseBeanUp.UserPwd = SnSee.Module.User.User.SetUserPassword(NewUserPwd);

        if (SnSee.Factory.Factory.UserBase.Update(_UserBaseBeanUp, _UserBaseBean.ID.Value))
        {
            SnSee.Module.User.User.UserLogout(); SnSee.Tool.MessageTool.MessageBox(this.Page, "Modify the success of your password, please re-visit!", "Login.aspx");
        }
    }
}
