﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;
using SnSee.Factory;

public partial class SystemControls_ArticleClassName : System.Web.UI.UserControl
{
    protected string ArticleClassName;

    /// <summary>
    /// 语言版本标识
    /// </summary>
    private string _EditionKey;
    /// <summary>
    /// 语言版本标识
    /// </summary>
    public string EditionKey
    {
        get
        {
            if (string.IsNullOrEmpty(_EditionKey))
            {
                if (Request.QueryString["EditionKey"] != null)
                {
                    _EditionKey = Request.QueryString["EditionKey"];
                }
                else if (!string.IsNullOrEmpty(SnSee.Config.WebConfig.EditionKey))
                {
                    _EditionKey = SnSee.Config.WebConfig.EditionKey;
                }
            }
            return _EditionKey;
        }
        set
        {
            _EditionKey = value;
        }
    }

    /// <summary>
    /// 文章分类ID
    /// </summary>
    private Guid? _ArticleClassID;
    /// <summary>
    /// 文章分类ID
    /// </summary>
    public Guid? ArticleClassID
    {
        get
        {
            if (Request.QueryString["ArticleClassID"] != null)
            {
                _ArticleClassID = SnSee.Tool.ConvertTool.GetGuid(Request.QueryString["ArticleClassID"]);
            }
            return _ArticleClassID;
        }
        set
        {
            _ArticleClassID = value;
        }
    }

    /// <summary>
    /// 分类标识
    /// </summary>
    private string _ArticleClassKey;
    /// <summary>
    /// 分类标识
    /// </summary>
    public string ArticleClassKey
    {
        get
        {
            if (string.IsNullOrEmpty(_ArticleClassKey))
            {
                if (Request.QueryString["ArticleClassKey"] != null)
                {
                    _ArticleClassKey = Request.QueryString["ArticleClassKey"];
                }
            }
            return _ArticleClassKey;
        }
        set
        {
            _ArticleClassKey = value;
        }
    }

    /// <summary>
    /// 文章分类实体数据
    /// </summary>
    private ArticleClassBean _ArticleClassBean;
    /// <summary>
    /// 文章分类实体数据
    /// </summary>
    public ArticleClassBean ArticleClassBean
    {
        get
        {
            return _ArticleClassBean;
        }
        set
        {
            _ArticleClassBean = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        EditionBean _EditionBean = null;
        if (!string.IsNullOrEmpty(EditionKey))
        {
            _EditionBean = (EditionBean)SnSee.Factory.Factory.Edition.Select("EditionKey='" + EditionKey + "' And State=1");
        }

        if (!ArticleClassID.HasValue)
        {
            if (!string.IsNullOrEmpty(ArticleClassKey))
            { SnSee.Bean.ArticleClassBean _ArticleClassBean = (SnSee.Bean.ArticleClassBean)SnSee.Factory.Factory.ArticleClass.Select("ClassKey='" + ArticleClassKey + "'");
                if (_ArticleClassBean != null)
                {
                    ArticleClassID = _ArticleClassBean.ID;  //如果指定了分类标识key，则取得对应的分类ID
                }
            }
        }

        if (!ArticleClassID.HasValue && _EditionBean != null)
        {//如果不存在文章分类ID,则取排序为第一的文章分类ID
            List<object> _ArticleClassBeanList = SnSee.Factory.Factory.ArticleClass.SelectList(1, "State=1 And IsChild=-1 And EditionID='{" + _EditionBean.ID.Value + "}'", "Order By SortOrder Asc");
            if (_ArticleClassBeanList != null && _ArticleClassBeanList.Count > 0)
            {
                _ArticleClassBean = (SnSee.Bean.ArticleClassBean)_ArticleClassBeanList[0];
            }
        }

        if (ArticleClassID.HasValue && ArticleClassBean == null)
        {//如果存在文章分类ID及不存在父级传递分类实体
            GetArticleClass(ArticleClassID.Value);
        }

        GetArticleClassData(_ArticleClassBean);
    }

    /// <summary>
    /// 取得文章分类数据
    /// </summary>
    /// <param name="ArticleClassID">文章分类ID</param>
    private void GetArticleClass(Guid ArticleClassID)
    {
        _ArticleClassBean = (ArticleClassBean)SnSee.Factory.Factory.ArticleClass.Select(ArticleClassID);
    }

    /// <summary>
    /// 取得文章单项分类数据
    /// </summary>
    /// <param name="_ArticleClassBean"></param>
    private void GetArticleClassData(ArticleClassBean _ArticleClassBean)
    {
        if (_ArticleClassBean != null)
        {
            ArticleClassName = _ArticleClassBean.ClassName;  //取得文章分类名称
        }
    }
}
