﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class SystemControls_ArticleTitle : System.Web.UI.UserControl
{
    protected string Title;

    /// <summary>
    /// 文章ID
    /// </summary>
    private Guid? _ArticleBaseID;
    /// <summary>
    /// 文章ID
    /// </summary>
    public Guid? ArticleBaseID
    {
        get
        {
            if (Request.QueryString["ArticleBaseID"] != null)
            {
                _ArticleBaseID = SnSee.Tool.ConvertTool.GetGuid(Request.QueryString["ArticleBaseID"]);
            }
            return _ArticleBaseID;
        }
        set
        {
            _ArticleBaseID = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (ArticleBaseID.HasValue)
        {
            GetArticle(ArticleBaseID.Value);
        }
    }

    /// <summary>
    /// 取得文章数据
    /// </summary>
    /// <param name="ArticleBaseID">文章ID</param>
    private void GetArticle(Guid ArticleBaseID)
    { SnSee.Bean.ArticleBaseBean _ArticleBaseBean = (SnSee.Bean.ArticleBaseBean)SnSee.Factory.Factory.ArticleBase.Select(ArticleBaseID);
        if (_ArticleBaseBean != null)
        {
            Title = _ArticleBaseBean.Title;
        }
    }
}
