﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Factory;
using SnSee.Bean;

public partial class SystemControls_Info : System.Web.UI.UserControl
{
    #region 说明
    //因为存在多种语言版本资料，所以必须指定语言版本标识(EditionKey)及企业信息标识(InfoKey)，两个标识在页面上直接指定即可，
    //比如：<uc5:Info ID="Info1" runat="server" EditionKey="英文版" InfoKey="公司介绍" />，其中的“EditionKey”就是语言版本标识，“英文版”是标识码，
    //这个“英文版”标识码是管理员在后台设置语言版本时自定义的编码，可以为任意字符
    //“InfoKey”就是企业信息标识，“公司介绍”是标识码，也是管理员在后台的自定义设置，可以为任意字符
    #endregion

    protected string Body;

    /// <summary>
    /// 企业信息标识
    /// </summary>
    private string _InfoKey;
    /// <summary>
    /// 企业信息标识
    /// </summary>
    public string InfoKey
    {
        get
        {
            if (Request.QueryString["InfoKey"] != null)
            {
                _InfoKey = Request.QueryString["InfoKey"];
            }
            return _InfoKey;
        }
        set
        {
            _InfoKey = value;
        }
    }

    /// <summary>
    /// 语言版本标识
    /// </summary>
    private string _EditionKey;
    /// <summary>
    /// 语言版本标识
    /// </summary>
    public string EditionKey
    {
        get
        {
            if (string.IsNullOrEmpty(_EditionKey))
            {
                if (Request.QueryString["EditionKey"] != null)
                {
                    _EditionKey = Request.QueryString["EditionKey"];
                }
                else if (!string.IsNullOrEmpty(SnSee.Config.WebConfig.EditionKey))
                {
                    _EditionKey = SnSee.Config.WebConfig.EditionKey;
                }
            }
            return _EditionKey;
        }
        set
        {
            _EditionKey = value;
        }
    }

    /// <summary>
    /// 内容显示长度
    /// </summary>
    private int? _TextLength;
    /// <summary>
    /// 内容显示长度
    /// </summary>
    public int? TextLength
    {
        get
        {
            return _TextLength;
        }
        set
        {
            _TextLength = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!string.IsNullOrEmpty(InfoKey) && !string.IsNullOrEmpty(EditionKey))
        {
            EditionBean _EditionBean = (EditionBean)SnSee.Factory.Factory.Edition.Select("EditionKey='" + EditionKey + "' And State=1");
            if (_EditionBean != null)
            {
                InfoClassBean _InfoClassBean = (InfoClassBean)SnSee.Factory.Factory.InfoClass.Select("ClassKey='" + InfoKey + "' And State=1");
                if (_InfoClassBean != null)
                {
                    InfoBaseBean _InfoBaseBean = (InfoBaseBean)SnSee.Factory.Factory.InfoBase.Select("InfoClassID='{" + _InfoClassBean.ID.Value + "}' And State=1 And EditionID='{" + _EditionBean.ID.Value + "}'");
                    if (_InfoBaseBean != null)
                    {
                        Body = _InfoBaseBean.Body;
                    }
                }
            }
        }

        if (TextLength.HasValue)
        {
            Body = SnSee.Tool.StringTool.CutString(Body, TextLength.Value, true);
        }
    }
}
