﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;

public partial class SystemControls_InfoTitle : System.Web.UI.UserControl
{
    protected string Title;

    /// <summary>
    /// 企业信息标识
    /// </summary>
    private string _InfoKey;
    /// <summary>
    /// 企业信息标识
    /// </summary>
    public string InfoKey
    {
        get
        {
            if (Request.QueryString["InfoKey"] != null)
            {
                _InfoKey = Request.QueryString["InfoKey"];
            }
            return _InfoKey;
        }
        set
        {
            _InfoKey = value;
        }
    }

    /// <summary>
    /// 语言版本标识
    /// </summary>
    private string _EditionKey;
    /// <summary>
    /// 语言版本标识
    /// </summary>
    public string EditionKey
    {
        get
        {
            if (string.IsNullOrEmpty(_EditionKey))
            {
                if (Request.QueryString["EditionKey"] != null)
                {
                    _EditionKey = Request.QueryString["EditionKey"];
                }
                else if (!string.IsNullOrEmpty(SnSee.Config.WebConfig.EditionKey))
                {
                    _EditionKey = SnSee.Config.WebConfig.EditionKey;
                }
            }
            return _EditionKey;
        }
        set
        {
            _EditionKey = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!string.IsNullOrEmpty(InfoKey) && !string.IsNullOrEmpty(EditionKey))
        {
            EditionBean _EditionBean = (EditionBean)SnSee.Factory.Factory.Edition.Select("EditionKey='" + EditionKey + "' And State=1");
            if (_EditionBean != null)
            {
                InfoClassBean _InfoClassBean = (InfoClassBean)SnSee.Factory.Factory.InfoClass.Select("ClassKey='" + InfoKey + "' And State=1");
                if (_InfoClassBean != null)
                {
                    InfoBaseBean _InfoBaseBean = (InfoBaseBean)SnSee.Factory.Factory.InfoBase.Select("InfoClassID='{" + _InfoClassBean.ID.Value + "}' And State=1 And EditionID='{" + _EditionBean.ID.Value + "}'");
                    if (_InfoBaseBean != null)
                    {
                        Title = _InfoBaseBean.Title;
                    }
                }
            }
        }
    }
}
