﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;
using SnSee.Factory;

public partial class SystemControls_ProductClassName : System.Web.UI.UserControl
{
    protected string ProductClassName;

    /// <summary>
    /// 语言版本标识
    /// </summary>
    private string _EditionKey;
    /// <summary>
    /// 语言版本标识
    /// </summary>
    public string EditionKey
    {
        get
        {
            if (string.IsNullOrEmpty(_EditionKey))
            {
                if (Request.QueryString["EditionKey"] != null)
                {
                    _EditionKey = Request.QueryString["EditionKey"];
                }
                else if (!string.IsNullOrEmpty(SnSee.Config.WebConfig.EditionKey))
                {
                    _EditionKey = SnSee.Config.WebConfig.EditionKey;
                }
            }
            return _EditionKey;
        }
        set
        {
            _EditionKey = value;
        }
    }

    /// <summary>
    /// 分类标识
    /// </summary>
    private string _ProductClassKey;
    /// <summary>
    /// 分类标识
    /// </summary>
    public string ProductClassKey
    {
        get
        {
            if (string.IsNullOrEmpty(_ProductClassKey))
            {
                if (Request.QueryString["ProductClassKey"] != null)
                {
                    _ProductClassKey = Request.QueryString["ProductClassKey"];
                }
            }
            return _ProductClassKey;
        }
        set
        {
            _ProductClassKey = value;
        }
    }

    /// <summary>
    /// 产品分类ID
    /// </summary>
    private Guid? _ProductClassID;
    /// <summary>
    /// 产品分类ID
    /// </summary>
    public Guid? ProductClassID
    {
        get
        {
            if (Request.QueryString["ProductClassID"] != null)
            {
                _ProductClassID = SnSee.Tool.ConvertTool.GetGuid(Request.QueryString["ProductClassID"]);
            }
            return _ProductClassID;
        }
        set
        {
            _ProductClassID = value;
        }
    }

    /// <summary>
    /// 产品分类实体数据
    /// </summary>
    private ProductClassBean _ProductClassBean;
    /// <summary>
    /// 产品分类实体数据
    /// </summary>
    public ProductClassBean ProductClassBean
    {
        get
        {
            return _ProductClassBean;
        }
        set
        {
            _ProductClassBean = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        EditionBean _EditionBean = null;
        if (!string.IsNullOrEmpty(EditionKey))
        {
            _EditionBean = (EditionBean)SnSee.Factory.Factory.Edition.Select("EditionKey='" + EditionKey + "' And State=1");
        }

        if (!ProductClassID.HasValue)
        {
            if (!string.IsNullOrEmpty(ProductClassKey))
            { SnSee.Bean.ProductClassBean _ProductClassBean = (SnSee.Bean.ProductClassBean)SnSee.Factory.Factory.ProductClass.Select("ClassKey='" + ProductClassKey + "'");
                if (_ProductClassBean != null)
                {
                    ProductClassID = _ProductClassBean.ID;  //如果指定了分类标识key，则取得对应的分类ID
                }
            }
        }

        if (!ProductClassID.HasValue && _EditionBean != null)
        {//如果不存在产品分类ID,则取排序为第一的默认产品分类ID
            List<object> _ProductClassBeanList = SnSee.Factory.Factory.ProductClass.SelectList(1, "State=1 And IsDefault=-1 And EditionID='{" + _EditionBean.ID.Value + "}'", "Order By SortOrder Asc");
            if (_ProductClassBeanList != null && _ProductClassBeanList.Count > 0)
            {
                _ProductClassBean = (SnSee.Bean.ProductClassBean)_ProductClassBeanList[0];
            }
        }

        if (ProductClassID.HasValue && ProductClassBean == null)
        {//如果存在产品分类ID及不存在父级传递分类实体
            GetProductClass(ProductClassID.Value);
        }

        GetProductClassData(_ProductClassBean);
    }

    /// <summary>
    /// 取得产品分类数据
    /// </summary>
    /// <param name="ProductClassID">产品分类ID</param>
    private void GetProductClass(Guid ProductClassID)
    {
        _ProductClassBean = (ProductClassBean)SnSee.Factory.Factory.ProductClass.Select(ProductClassID);
    }

    /// <summary>
    /// 取得产品单项分类数据
    /// </summary>
    /// <param name="_ProductClassBean"></param>
    private void GetProductClassData(ProductClassBean _ProductClassBean)
    {
        if (_ProductClassBean != null)
        {
            ProductClassName = _ProductClassBean.ClassName;  //取得产品分类名称
        }
    }
}
