﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class SystemControls_ProductName : System.Web.UI.UserControl
{
    protected string ProductName;

    /// <summary>
    /// 语言版本标识
    /// </summary>
    private string _EditionKey;
    /// <summary>
    /// 语言版本标识
    /// </summary>
    public string EditionKey
    {
        get
        {
            if (string.IsNullOrEmpty(_EditionKey))
            {
                if (Request.QueryString["EditionKey"] != null)
                {
                    _EditionKey = Request.QueryString["EditionKey"];
                }
                else if (!string.IsNullOrEmpty(SnSee.Config.WebConfig.EditionKey))
                {
                    _EditionKey = SnSee.Config.WebConfig.EditionKey;
                }
            }
            return _EditionKey;
        }
        set
        {
            _EditionKey = value;
        }
    }

    /// <summary>
    /// 产品ID
    /// </summary>
    private Guid? _ProductBaseID;
    /// <summary>
    /// 产品ID
    /// </summary>
    public Guid? ProductBaseID
    {
        get
        {
            if (Request.QueryString["ProductBaseID"] != null)
            {
                _ProductBaseID = SnSee.Tool.ConvertTool.GetGuid(Request.QueryString["ProductBaseID"]);
            }
            return _ProductBaseID;
        }
        set
        {
            _ProductBaseID = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    { SnSee.Bean.EditionBean _EditionBean = null;
        if (!string.IsNullOrEmpty(EditionKey))
        {
            _EditionBean = (SnSee.Bean.EditionBean)SnSee.Factory.Factory.Edition.Select("EditionKey='" + EditionKey + "' And State=1");
        }

        if (_EditionBean != null && ProductBaseID.HasValue)
        {
            GetProduct(_EditionBean.ID.Value, ProductBaseID.Value);
        }
    }

    /// <summary>
    /// 取得产品数据
    /// </summary>
    /// <param name="EditionID">语言标识ID</param>
    /// <param name="ProductBaseID">产品ID</param>
    private void GetProduct(Guid EditionID, Guid ProductBaseID)
    { SnSee.Bean.ProductListBean _ProductListBean = (SnSee.Bean.ProductListBean)SnSee.Factory.Factory.ProductList.Select("ProductBaseID='{" + ProductBaseID + "}' And EditionID='{" + EditionID + "}'");
        if (_ProductListBean != null)
        {
            ProductName = _ProductListBean.Name;
        }
    }
}
