﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;

public partial class SystemControls_SalesClassName : System.Web.UI.UserControl
{
    protected string SalesClassName;

    /// <summary>
    /// 语言版本标识
    /// </summary>
    private string _EditionKey;
    /// <summary>
    /// 语言版本标识
    /// </summary>
    public string EditionKey
    {
        get
        {
            if (string.IsNullOrEmpty(_EditionKey))
            {
                if (Request.QueryString["EditionKey"] != null)
                {
                    _EditionKey = Request.QueryString["EditionKey"];
                }
                else if (!string.IsNullOrEmpty(SnSee.Config.WebConfig.EditionKey))
                {
                    _EditionKey = SnSee.Config.WebConfig.EditionKey;
                }
            }
            return _EditionKey;
        }
        set
        {
            _EditionKey = value;
        }
    }

    /// <summary>
    /// 销售网络分类ID
    /// </summary>
    private Guid? _SalesClassID;
    /// <summary>
    /// 销售网络分类ID
    /// </summary>
    public Guid? SalesClassID
    {
        get
        {
            if (Request.QueryString["SalesClassID"] != null)
            {
                _SalesClassID = SnSee.Tool.ConvertTool.GetGuid(Request.QueryString["SalesClassID"]);
            }
            return _SalesClassID;
        }
        set
        {
            _SalesClassID = value;
        }
    }

    /// <summary>
    /// 销售网络分类实体数据
    /// </summary>
    private SalesClassBean _SalesClassBean;
    /// <summary>
    /// 销售网络分类实体数据
    /// </summary>
    public SalesClassBean SalesClassBean
    {
        get
        {
            return _SalesClassBean;
        }
        set
        {
            _SalesClassBean = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        EditionBean _EditionBean = null;
        if (!string.IsNullOrEmpty(EditionKey))
        {
            _EditionBean = (EditionBean)SnSee.Factory.Factory.Edition.Select("EditionKey='" + EditionKey + "' And State=1");
        }

        if (!SalesClassID.HasValue && _EditionBean != null)
        {//如果不存在销售网络分类ID,则取排序为第一的销售网络分类ID
            List<object> _SalesClassBeanList = SnSee.Factory.Factory.SalesClass.SelectList(1, "State=1 And IsChild=-1 And EditionID='{" + _EditionBean.ID.Value + "}'", "Order By SortOrder Asc");
            if (_SalesClassBeanList != null && _SalesClassBeanList.Count > 0)
            {
                _SalesClassBean = (SnSee.Bean.SalesClassBean)_SalesClassBeanList[0];
            }
        }

        if (SalesClassID.HasValue && SalesClassBean == null)
        {//如果存在销售网络分类ID及不存在父级传递分类实体
            GetSalesClass(SalesClassID.Value);
        }

        GetSalesClassData(_SalesClassBean);
    }

    /// <summary>
    /// 取得销售网络分类数据
    /// </summary>
    /// <param name="SalesClassID">销售网络分类ID</param>
    private void GetSalesClass(Guid SalesClassID)
    {
        _SalesClassBean = (SalesClassBean)SnSee.Factory.Factory.SalesClass.Select(SalesClassID);
    }

    /// <summary>
    /// 取得销售网络单项分类数据
    /// </summary>
    /// <param name="_SalesClassBean"></param>
    private void GetSalesClassData(SalesClassBean _SalesClassBean)
    {
        if (_SalesClassBean != null)
        {
            SalesClassName = _SalesClassBean.ClassName;  //取得销售网络分类名称
        }
    }
}
