﻿<%@ control language="C#" autoeventwireup="true" inherits="Controls_ProductModule, ShanRui.WebSite" %>
<asp:DataList ID="ProductList" runat="server" CssClass="productList" 
    EnableViewState="False" RepeatDirection="Horizontal" >
    <ItemTemplate>
        <div class="productImage">
            <a href='<%#ShanRui.Web.Website.IsURLRewriter() ? String.Format("{1}-D3_{0}_{2}.{3}",Eval("ProductId").ToString(),Eval("FileName").ToString(),ShanRui.Web.Website.GetLanguage(),ShanRui.Web.Website.HTMLExtension()) :  String.Format("ProductDetail.aspx?id={0}&fileName={1}&Language={2}",Eval("ProductId").ToString(),Eval("FileName").ToString(),ShanRui.Web.Website.GetLanguage()) %>'><asp:Image ID="SmallImage" Width="<%# new Unit(_width) %>" Height="<%# new Unit(_height) %>"  runat="server" ImageUrl='<%# Bind("PicPathSmall") %>' AlternateText='<%# Bind("ProductName") %>' /></a>
        </div>
        <div class="productText">
            <div class="productNameBox">
                <asp:Label ID="ClassName" CssClass="productClassName" runat="server" Text='<%# String.Format("[{0}]",Eval("ClassName").ToString()) %>' Visible="<%# _showClassName %>"></asp:Label>
                <asp:HyperLink ID="ProductName" CssClass="productName" runat="server" NavigateUrl='<%#ShanRui.Web.Website.IsURLRewriter() ? String.Format("~/{1}-D3_{0}_{2}.{3}",Eval("ProductId").ToString(),Eval("FileName").ToString(),ShanRui.Web.Website.GetLanguage(),ShanRui.Web.Website.HTMLExtension()) :  String.Format("~/ProductDetail.aspx?id={0}&fileName={1}&Language={2}",Eval("ProductId").ToString(),Eval("FileName").ToString(),ShanRui.Web.Website.GetLanguage()) %>' Text='<%# ShanRui.Web.Strings.CutLenStr(Eval("ProductName").ToString(),_titleLength) %>' ToolTip='<%# Eval("ProductName") %>' Target="_blank"></asp:HyperLink>
            </div>
            <div class="productNumberBox">
                <asp:Label ID="ProductNumberLabel" meta:resourcekey="ProductNumberLabel" CssClass="productNumberLabel" EnableViewState="False" runat="server" Text=""></asp:Label>
                <asp:Label ID="ProductNumber" runat="server" Text='<%# Eval("ProductNumber") %>' CssClass="productNumber" Visible="<%# _showProductNumber %>"></asp:Label>
            </div>
            <div class="priceBox">
                <asp:Label ID="PriceLabel" meta:resourcekey="PriceLabel" CssClass="priceLabel" EnableViewState="False" runat="server" Text=""></asp:Label>
                <asp:Label ID="Price" runat="server" Text='<%# _moneyUnit+Convert.ToSingle(Eval("Price")).ToString(".00") %>' CssClass="price" Visible="<%# _showPrice %>"></asp:Label>
            </div>
            <div class="productShortContent">
                <asp:Literal ID="ProductShortContent" runat="server" Text='<%# ShanRui.Web.Strings.CutLenStr(Eval("ProductShortContent").ToString(),_shortContentLength) %>'></asp:Literal>
            </div>
            <div class="cartButtonBox">
                <asp:Button ID="CartButton" OnClientClick='<%# String.Format("return CartOpen({0},{1});",Eval("ProductId").ToString(),ShanRui.Web.Website.GetLanguage()) %>' meta:resourcekey="CartButton" CssClass="cartButton" runat="server" EnableViewState="False" CausesValidation="False" UseSubmitBehavior="False" />
            </div>
        </div>
    </ItemTemplate>
    <ItemStyle Font-Bold="False" Font-Italic="False" Font-Overline="False" Font-Strikeout="False"
Font-Underline="False" CssClass="productItem" />
    <AlternatingItemStyle CssClass="productAlternating" />
    <SeparatorStyle CssClass="productSeparator" />
    <HeaderStyle CssClass="productHeader" />
</asp:DataList>