﻿//会员登陆控件js文件
$(document).ready(function() {
    //会员登陆ajax
    $(".memberBox").each(function() {
        var myMemberBox = $(this);
        //显示ajax请求loading,在ajax请求时调用
        function showAjaxLoading() {
            myMemberBox.find(".loading").show("normal");
        }
        //隐藏ajax请求loading
        function hideAjaxLoading() {
            myMemberBox.find(".loading").hide("normal");
        }
        //检查是否登陆,ajax请求验证登陆
        showAjaxLoading();
        $.ajax({
            type: "POST",
            contentType: "application/json",
            url: "WebService/WS_Member.asmx/Validate",
            data: "{}",
            dataType: 'json',
            success: function(result) {
                if (result!="null") {
                    $(".memberBox").find(".memberLogin").hide("normal");
                    $(".memberBox").find(".memberLoginBox").show("normal");
                    myMemberBox.find(".loginName").text(result);
                }
                else {
                    //所有登陆控件都退出
                    $(".memberBox").find(".memberLogin").show("normal");
                    $(".memberBox").find(".memberLoginBox").hide("normal");
                    //清除用户密码
                    myMemberBox.find(".memberName").val("");
                    myMemberBox.find(".password").val("");
                }
                hideAjaxLoading();
            }
        });
        //登陆按钮事件
        myMemberBox.find(".loginBt").click(function() {
            var memberName = myMemberBox.find(".memberName").val();
            var passWord = myMemberBox.find(".password").val();
            //初始化，隐藏所有错误信息
            myMemberBox.find(".loginErrorSummary").hide();
            myMemberBox.find(".loginErrorSummary li").hide();
            myMemberBox.find(".memberNameRequiredLabel").hide();
            myMemberBox.find(".passwordRequiredLabel").hide();
            var isValid = true;
            //用户名必须填写
            if (memberName == "" || memberName == null) {
                myMemberBox.find(".loginErrorSummary").show();
                myMemberBox.find(".loginErrorSummary li").eq(0).show();
                myMemberBox.find(".memberNameRequiredLabel").show();
                isValid = false;
            }
            //密码必须填写
            if (passWord == "" || passWord == null) {
                myMemberBox.find(".loginErrorSummary").show();
                myMemberBox.find(".loginErrorSummary li").eq(1).show();
                myMemberBox.find(".passwordRequiredLabel").show();
                isValid = false;
            }
            if (isValid) {
                //ajax请求验证登陆
                showAjaxLoading();
                $.ajax({
                    type: "POST",
                    contentType: "application/json",
                    url: "WebService/WS_Member.asmx/Login",
                    data: "{memberName:'" + memberName + "',password:'" + passWord + "'}",
                    dataType: 'json',
                    success: function(result) {
                        if (result) {
                            //所有登陆都登入
                            $(".memberBox").find(".memberLogin").hide("normal");
                            $(".memberBox").find(".memberLoginBox").show("normal");
                            myMemberBox.find(".loginName").text(memberName);
                        }
                        else {
                            myMemberBox.find(".loginErrorSummary").show();
                            myMemberBox.find(".loginErrorSummary li").eq(2).show();
                            //清除用户密码
                            myMemberBox.find(".memberName").val("");
                            myMemberBox.find(".password").val("");
                        }
                        hideAjaxLoading(); //隐藏loading
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        myMemberBox.find(".loginErrorSummary").show();
                        myMemberBox.find(".loginErrorSummary li").eq(3).show();
                        hideAjaxLoading();
                    }
                });

            }
        });
        //错误信息关闭
        myMemberBox.find(".loginErrorSummary").click(function() {
            $(this).hide();
        });
        //退出登陆
        myMemberBox.find(".outLinkButton").click(function() {
            showAjaxLoading();
            $.ajax({
                type: "POST",
                contentType: "application/json",
                url: "WebService/WS_Member.asmx/Out",
                data: "{}",
                dataType: 'json',
                success: function(result) {
                    //所有登陆控件都退出
                    $(".memberBox").find(".memberLogin").show("normal");
                    $(".memberBox").find(".memberLoginBox").hide("normal");
                    //清除用户密码
                    myMemberBox.find(".memberName").val("");
                    myMemberBox.find(".password").val("");
                    hideAjaxLoading();
                }
            });
            return false;
        });
    });
})
        
