﻿<%@ page language="C#" masterpagefile="~/manage/Main.master" autoeventwireup="true" inherits="manage_Article, ShanRui.WebSite" validaterequest="false" title="内容管理" %>

<%@ Register Assembly="FredCK.FCKeditorV2" Namespace="FredCK.FCKeditorV2" TagPrefix="FCKeditorV2" %>
<asp:Content ID="Content2" ContentPlaceHolderID="MidContent" runat="Server">
    <div id="main">
        <asp:UpdatePanel ID="MsgUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:Label ID="Msg" runat="server" Text="" CssClass="msg" Visible="False" EnableViewState="False"></asp:Label>
            </ContentTemplate>
        </asp:UpdatePanel>
        <table width="100%" border="0" cellpadding="2" cellspacing="1" bgcolor="#D7D7D7"
            id="mainTopTable">
            <tr>
                <td colspan="5" bgcolor="#FFFFFF" class="mainTitle">
                    "<asp:Label ID="SearchMenuName" runat="server" ForeColor="Black"></asp:Label>" 文章检索&nbsp;
                </td>
            </tr>
            <tr>
                <td align="right" bgcolor="#FFFFFF">
                    属于分类:
                </td>
                <td bgcolor="#ffffff">
                    <asp:DropDownList ID="SearchClassList" runat="server">
                    </asp:DropDownList>
                </td>
                <td bgcolor="#FFFFFF" align="right">
                    文章标题/内容:
                </td>
                <td bgcolor="#FFFFFF">
                    &nbsp;<asp:TextBox ID="SearchKey" runat="server" CssClass="inputText"></asp:TextBox>
                    <asp:HiddenField ID="IsSearch" runat="server" Value="0" />
                </td>
                <td bgcolor="#ffffff">
                    <asp:Button ID="SearchBt" runat="server" CssClass="inputBt" Text="文章检索" OnClick="Search_Click"
                        ValidationGroup="ArticleSearch" />
                </td>
            </tr>
        </table>
        <asp:UpdatePanel ID="ArticleListUpdatePanel" UpdateMode="Conditional" runat="server">
            <Triggers>
                <asp:AsyncPostBackTrigger ControlID="SearchBt" />
            </Triggers>
            <ContentTemplate>
                <asp:GridView ID="ArticleList" runat="server" AllowPaging="True" AutoGenerateColumns="False"
                    OnPageIndexChanging="ArticleList_PageIndexChanging" DataKeyNames="ArticleId,ArticleClassId"
                    OnRowCancelingEdit="ArticleList_RowCancelingEdit" OnRowEditing="ArticleList_RowEditing"
                    OnRowUpdating="ArticleList_RowUpdating" PageSize="11" OnRowDeleting="ArticleList_RowDeleting"
                    CellPadding="0" CssClass="gv" Width="100%" EmptyDataText="暂无任何文章" OnRowDataBound="ArticleList_RowDataBound"
                    OnRowCommand="ArticleList_RowCommand">
                    <Columns>
                        <asp:BoundField DataField="ArticleId" HeaderText="ID">
                            <ControlStyle CssClass="gvOrderId" />
                        </asp:BoundField>
                        <asp:BoundField DataField="ClassName" HeaderText="所属分类" ReadOnly="True" SortExpression="ClassName" />
                        <asp:BoundField DataField="Title" HeaderText="文章标题" ReadOnly="True" SortExpression="Title" />
                        <asp:BoundField DataField="Author" HeaderText="文章作者" ReadOnly="True" SortExpression="Author" />
                        <asp:BoundField DataField="AddTime" HeaderText="添加时间" ReadOnly="True" SortExpression="AddTime" />
                        <asp:TemplateField HeaderText="操作" ShowHeader="False">
                            <ItemStyle CssClass="gvCommandField" />
                            <ItemTemplate>
                                <asp:Button ID="EditBt" runat="server" CausesValidation="False" CommandName="editArticle"
                                    CommandArgument='<%# Eval("ArticleId").ToString().Trim() %>' Text="编辑" />
                                &nbsp;<asp:Button ID="DelBt" runat="server" CausesValidation="False" CommandName="Delete"
                                    Text="删除" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="添加文章">
                            <ItemStyle CssClass="gvBtAField" />
                            <ItemTemplate>
                                <asp:Button ID="AddBt" runat="server" CommandName="addArticle" CommandArgument='<%# Eval("ArticleId").ToString().Trim() %>'
                                    Text="添加文章" CssClass="addBt" CausesValidation="False" />
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                    <RowStyle CssClass="gvRow" />
                    <EditRowStyle CssClass="gvEditRow" />
                    <PagerStyle CssClass="gvPage" />
                    <HeaderStyle CssClass="gvHeader" />
                    <AlternatingRowStyle CssClass="gvAlternatingRow" />
                </asp:GridView>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:UpdatePanel ID="ArticleSaveUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <table width="100%" border="0" cellpadding="2" cellspacing="1" bgcolor="#D7D7D7"
                    id="mainBottTable">
                    <tr>
                        <td colspan="2" bgcolor="#FFFFFF" class="mainTitle">
                            "<asp:Label ID="MenuName" runat="server" ForeColor="Black"></asp:Label>"<asp:Literal
                                ID="SaveType" runat="server" Text="添加"></asp:Literal>文章&nbsp;
                            <asp:HiddenField ID="EditId" runat="server" />
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF" class="mainContentLeftTd">
                            所属分类:
                        </td>
                        <td bgcolor="#FFFFFF" class="mainContentRightTd">
                            <asp:DropDownList ID="ArticleClassList" runat="server">
                            </asp:DropDownList>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            文章标题:
                        </td>
                        <td bgcolor="#FFFFFF">
                            <asp:TextBox ID="ArticleTitle" runat="server"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="ArticleTitle"
                                Display="Dynamic" ErrorMessage="文章标题必须填写"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            文章编辑:
                        </td>
                        <td bgcolor="#FFFFFF">
                            <asp:TextBox ID="Author" runat="server"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="Author"
                                Display="Dynamic" ErrorMessage="文章编辑必须填写"></asp:RequiredFieldValidator>&nbsp;
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            添加时间:
                        </td>
                        <td bgcolor="#FFFFFF">
                            <asp:TextBox ID="AddTime" runat="server"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ControlToValidate="AddTime"
                                Display="Dynamic" ErrorMessage="添加时间必须填写"></asp:RequiredFieldValidator>&nbsp;
                            <asp:CustomValidator ID="CustomValidator1" runat="server" ControlToValidate="AddTime"
                                Display="Dynamic" ErrorMessage="时间格式错误！" OnServerValidate="CustomValidator1_ServerValidate"></asp:CustomValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            文章内容:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" align="left" bgcolor="#ffffff">
                            <div class="mainNoLeftTd">
                                <FCKeditorV2:FCKeditor ID="ArticleContent" runat="server" Height="400px" Width="100%">
                                </FCKeditorV2:FCKeditor>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:Button ID="Save" runat="server" Text="添加文章" CssClass="inputBt" OnClick="Save_Click" />
                        </td>
                    </tr>
                </table>
            </ContentTemplate>
        </asp:UpdatePanel>
    </div>
</asp:Content>
