﻿<%@ page language="C#" masterpagefile="~/Manage/Main.master" autoeventwireup="true" inherits="manage_CustomTag, ShanRui.WebSite" title="自定义标签列表" validaterequest="false" %>

<%@ Register Assembly="FredCK.FCKeditorV2" Namespace="FredCK.FCKeditorV2" TagPrefix="FCKeditorV2" %>
<asp:Content ID="Content2" ContentPlaceHolderID="MidContent" runat="Server">
    <div id="main">
        <asp:UpdatePanel ID="MsgUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:Label ID="Msg" runat="server" Text="" CssClass="msg" Visible="False" EnableViewState="False"></asp:Label>
            </ContentTemplate>
        </asp:UpdatePanel>
        <table width="100%" border="0" cellpadding="2" cellspacing="1" bgcolor="#D7D7D7"
            id="mainTopTable">
            <tr>
                <td colspan="3" bgcolor="#FFFFFF" class="mainTitle">
                    自定义标签检索&nbsp;
                </td>
            </tr>
            <tr>
                <td bgcolor="#FFFFFF" align="right">
                    标签名/内容:
                </td>
                <td bgcolor="#FFFFFF">
                    &nbsp;<asp:TextBox ID="CustomTagNameKey" runat="server" CssClass="inputText"></asp:TextBox>
                    <asp:HiddenField ID="IsSearch" runat="server" Value="0" />
                </td>
                <td bgcolor="#ffffff">
                    <asp:Button ID="SearchBt" runat="server" CssClass="inputBt" Text="标签检索" OnClick="Search_Click"
                        ValidationGroup="NoticeSearch" />
                </td>
            </tr>
        </table>
        <asp:UpdatePanel ID="CustomTagListUpdatePanel" UpdateMode="Conditional" runat="server">
            <Triggers>
                <asp:AsyncPostBackTrigger ControlID="SearchBt" />
            </Triggers>
            <ContentTemplate>
                <asp:GridView ID="CustomTagList" runat="server" AllowPaging="True" AutoGenerateColumns="False"
                    OnPageIndexChanging="NoticeList_PageIndexChanging" DataKeyNames="CustomTagId"
                    OnRowCancelingEdit="NoticeList_RowCancelingEdit" OnRowEditing="NoticeList_RowEditing"
                    OnRowUpdating="NoticeList_RowUpdating" PageSize="11" OnRowDeleting="NoticeList_RowDeleting"
                    CellPadding="0" CssClass="gv" Width="100%" EmptyDataText="暂无任何标签" OnRowDataBound="CustomTagList_RowDataBound"
                    OnRowCommand="CustomTagList_RowCommand">
                    <Columns>
                        <asp:BoundField DataField="CustomTagId" HeaderText="ID">
                            <ControlStyle CssClass="gvOrderId" />
                        </asp:BoundField>
                        <asp:BoundField DataField="CustomTagName" HeaderText="标签名称" ReadOnly="True" SortExpression="CustomTagName" />
                        <asp:TemplateField HeaderText="操作" ShowHeader="False">
                            <ItemStyle CssClass="gvCommandField" />
                            <ItemTemplate>
                                <asp:Button ID="EditBt" runat="server" CausesValidation="False" CommandName="editCustomTag"
                                    CommandArgument='<%# Eval("CustomTagId").ToString().Trim() %>' Text="编辑" />&nbsp;<asp:Button
                                        ID="DelBt" runat="server" CausesValidation="False" CommandName="Delete" Text="删除" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="添加自定义标签">
                            <ItemStyle CssClass="gvBtAField" />
                            <ItemTemplate>
                                <asp:Button ID="AddBt" runat="server" CommandName="addCustomTag" CommandArgument='<%# Eval("CustomTagId").ToString().Trim() %>'
                                    Text="添加标签" CssClass="addBt" CausesValidation="False" />
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                    <RowStyle CssClass="gvRow" />
                    <EditRowStyle CssClass="gvEditRow" />
                    <PagerStyle CssClass="gvPage" />
                    <HeaderStyle CssClass="gvHeader" />
                    <AlternatingRowStyle CssClass="gvAlternatingRow" />
                </asp:GridView>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:UpdatePanel ID="CustomTagSaveUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <table width="100%" border="0" cellpadding="2" cellspacing="1" bgcolor="#D7D7D7"
                    id="mainBottTable">
                    <tr>
                        <td colspan="2" bgcolor="#FFFFFF" class="mainTitle">
                            <asp:Literal ID="SaveType" runat="server" Text="添加"></asp:Literal>自定义标签&nbsp;
                            <asp:HiddenField ID="EditId" runat="server" />
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF" class="mainContentLeftTd">
                            标签名称:
                        </td>
                        <td bgcolor="#FFFFFF" class="mainContentRightTd">
                            <asp:TextBox ID="CustomTagName" runat="server"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="CustomTagName"
                                Display="Dynamic" ErrorMessage="标签名称必须填写"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            标签说明:
                        </td>
                        <td bgcolor="#FFFFFF">
                            <asp:TextBox ID="CustomTagRemark" runat="server" TextMode="MultiLine"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            标签内容:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" align="left" bgcolor="#ffffff">
                            <div class="mainNoLeftTd">
                                <FCKeditorV2:FCKeditor ID="CustomTagContent" runat="server" Height="400px" Width="100%">
                                </FCKeditorV2:FCKeditor>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:Button ID="Save" runat="server" Text="添加标签" CssClass="inputBt" OnClick="Save_Click" />
                        </td>
                    </tr>
                </table>
            </ContentTemplate>
        </asp:UpdatePanel>
    </div>
</asp:Content>
