﻿<%@ page language="C#" masterpagefile="~/Manage/Main.master" autoeventwireup="true" inherits="manage_FriendLink, ShanRui.WebSite" title="友情链接管理" %>

<asp:Content ID="Content2" ContentPlaceHolderID="MidContent" runat="Server">
    <div id="main">
        <asp:UpdatePanel ID="MsgUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:Label ID="Msg" runat="server" Text="" CssClass="msg" Visible="False" EnableViewState="False"></asp:Label>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:UpdatePanel ID="FriendLinkListUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:GridView ID="FriendLinkList" runat="server" AllowPaging="True" AutoGenerateColumns="False"
                    OnPageIndexChanging="FriendLinkList_PageIndexChanging" DataKeyNames="FriendLinkId"
                    OnRowCancelingEdit="FriendLinkList_RowCancelingEdit" OnRowEditing="FriendLinkList_RowEditing"
                    OnRowUpdating="FriendLinkList_RowUpdating" PageSize="11" OnRowDeleting="FriendLinkList_RowDeleting"
                    CellPadding="0" CssClass="gv" Width="100%" EmptyDataText="暂无任何友情链接" OnRowDataBound="FriendLinkList_RowDataBound"
                    OnRowCommand="FriendLinkList_RowCommand">
                    <Columns>
                        <asp:BoundField DataField="FriendLinkId" HeaderText="ID">
                            <ControlStyle CssClass="gvOrderId" />
                        </asp:BoundField>
                        <asp:TemplateField HeaderText="链接类型">
                            <ItemTemplate>
                                <asp:Label ID="Label1" runat="server" Text='<%# Eval("Type").ToString()=="True"?"图片链接":"文字链接" %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:HyperLinkField DataNavigateUrlFields="url" DataTextField="url" HeaderText="链接地址"
                            Target="_blank" />
                        <asp:BoundField DataField="Title" HeaderText="链接文字" ReadOnly="True" SortExpression="Title"
                            NullDisplayText="无" />
                        <asp:TemplateField HeaderText="Logo图片">
                            <ItemTemplate>
                                <asp:HyperLink ID="HyperLink1" runat="server" NavigateUrl='<%# Bind("LogoPath") %>'
                                    Target="_blank" Text='<%# Eval("LogoPath").ToString()==""?"无":"预览" %>'></asp:HyperLink>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="操作" ShowHeader="False">
                            <ItemStyle CssClass="gvCommandField" />
                            <ItemTemplate>
                                <asp:Button ID="EditBt" runat="server" CausesValidation="False" CommandName="editFriendLink"
                                    CommandArgument='<%# Eval("FriendLinkId").ToString().Trim() %>' Text="编辑" /><asp:Button
                                        ID="DelBt" runat="server" CausesValidation="False" CommandName="Delete" Text="删除" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="添加友情链接">
                            <ItemStyle CssClass="gvBtAField" />
                            <ItemTemplate>
                                <asp:Button ID="AddBt" runat="server" CommandName="addFriendLink" CommandArgument='<%# Eval("FriendLinkId").ToString().Trim() %>'
                                    Text="添加链接" CssClass="addBt" CausesValidation="False" />
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                    <RowStyle CssClass="gvRow" />
                    <EditRowStyle CssClass="gvEditRow" />
                    <PagerStyle CssClass="gvPage" />
                    <HeaderStyle CssClass="gvHeader" />
                    <AlternatingRowStyle CssClass="gvAlternatingRow" />
                </asp:GridView>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:UpdatePanel ID="FriendLinkSaveUpdatePanel" UpdateMode="Conditional" 
            runat="server" oninit="FriendLinkSaveUpdatePanel_Init">
            <ContentTemplate>
                <table width="100%" border="0" cellpadding="2" cellspacing="1" bgcolor="#D7D7D7"
                    id="mainBottTable">
                    <tr>
                        <td colspan="2" bgcolor="#FFFFFF" class="mainTitle">
                            <asp:Literal ID="SaveType" runat="server" Text="添加"></asp:Literal>友情链接<asp:HiddenField
                                ID="EditId" runat="server" />
                        </td>
                    </tr>
                    <tr id="typeTr">
                        <td align="right" bgcolor="#ffffff" class="mainLeftTd">
                            链接类型:
                        </td>
                        <td bgcolor="#ffffff">
                            <asp:RadioButtonList ID="TypeList" runat="server" CssClass="radio" RepeatDirection="Horizontal"
                                RepeatLayout="Flow">
                                <asp:ListItem onclick="radioFriendLink(this);" Selected="True" Value="false">文字链接</asp:ListItem>
                                <asp:ListItem onclick="radioFriendLink(this);" Value="true">图片链接</asp:ListItem>
                            </asp:RadioButtonList>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#ffffff">
                            链接地址:
                        </td>
                        <td bgcolor="#ffffff">
                            <asp:TextBox ID="Url" runat="server">http://</asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="Url"
                                Display="Dynamic" ErrorMessage="地址必须填写"></asp:RequiredFieldValidator>
                            <asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" ControlToValidate="Url"
                                Display="Dynamic" ErrorMessage="链接地址格式错误" ValidationExpression="http(s)?://([\w-]+\.)+[\w-]+(/[\w- ./?%&=]*)?"></asp:RegularExpressionValidator>
                        </td>
                    </tr>
                    <tr id="tr1">
                        <td align="right" bgcolor="#FFFFFF">
                            链接文字:
                        </td>
                        <td bgcolor="#FFFFFF">
                            <asp:TextBox ID="FriendLinkTitle" runat="server"></asp:TextBox>
                            <asp:CustomValidator ID="CustomValidator1" runat="server" ErrorMessage="链接文字必须填写"
                                OnServerValidate="CustomValidator1_ServerValidate"></asp:CustomValidator>
                        </td>
                    </tr>
                    <tr id="tr2" class="hide">
                        <td align="right" bgcolor="#ffffff">
                            Logo图片:
                        </td>
                        <td bgcolor="#ffffff" id="PicLogoTd">
                            <asp:HyperLink ID="PicLogoHyperLink" runat="server" Target="_blank" Visible="false">预览原图</asp:HyperLink>
                            <span class="explain" id="PicLogoEditSpan" runat="server" visible="false">不修改请留空</span>
                            <asp:HiddenField ID="PicLogo" runat="server" Value="无" EnableViewState="false" />
                            <iframe height="24" width="550" frameborder="0" scrolling="no" src="UpLoad.aspx?type=Logo&thisPath=FriendLink">
                            </iframe>
                            &nbsp;
                            <asp:CustomValidator ID="PicLogoCustomValidator" runat="server" Display="Dynamic"
                                ErrorMessage="logo路径必须选择" ClientValidationFunction="ValidationPicLogo"></asp:CustomValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#ffffff">
                            链接描述:
                        </td>
                        <td bgcolor="#ffffff">
                            <asp:TextBox ID="friendLinkDescribe" runat="server" Rows="3" TextMode="MultiLine"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:Button ID="Save" runat="server" Text="添加链接" CssClass="inputBt" OnClick="Save_Click" />
                        </td>
                    </tr>
                </table>
            </ContentTemplate>
        </asp:UpdatePanel>
    </div>

    <script language="JavaScript" type="text/javascript">
        radioFriendLinkLoad()//初始化显示
    </script>

</asp:Content>
