﻿<%@ page language="C#" masterpagefile="~/manage/Main.master" autoeventwireup="true" inherits="manage_JobList, ShanRui.WebSite" validaterequest="false" title="内容管理" %>

<%@ Register Assembly="FredCK.FCKeditorV2" Namespace="FredCK.FCKeditorV2" TagPrefix="FCKeditorV2" %>
<asp:Content ID="Content2" ContentPlaceHolderID="MidContent" runat="Server">
    <div id="main">
        <asp:UpdatePanel ID="MsgUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:Label ID="Msg" runat="server" Text="" CssClass="msg" Visible="False" EnableViewState="False"></asp:Label>
            </ContentTemplate>
        </asp:UpdatePanel>
        <table width="100%" border="0" cellpadding="2" cellspacing="1" bgcolor="#D7D7D7"
            id="mainTopTable">
            <tr>
                <td colspan="3" bgcolor="#FFFFFF" class="mainTitle">
                    "<asp:Label ID="SearchMenuName" runat="server" ForeColor="Black"></asp:Label>" 职位检索&nbsp;
                </td>
            </tr>
            <tr>
                <td bgcolor="#FFFFFF" align="right">
                    职位名称/详情:
                </td>
                <td bgcolor="#FFFFFF">
                    &nbsp;<asp:TextBox ID="SearchKey" runat="server" CssClass="inputText"></asp:TextBox>
                    <asp:HiddenField ID="IsSearch" runat="server" Value="0" />
                </td>
                <td bgcolor="#ffffff">
                    <asp:Button ID="SearchBt" runat="server" CssClass="inputBt" Text="职位检索" OnClick="Search_Click"
                        ValidationGroup="JobSearch" />
                </td>
            </tr>
        </table>
        <asp:UpdatePanel ID="JobListUpdatePanel" UpdateMode="Conditional" runat="server">
            <Triggers>
                <asp:AsyncPostBackTrigger ControlID="SearchBt" />
            </Triggers>
            <ContentTemplate>
                <asp:GridView ID="JobList" runat="server" AllowPaging="True" AutoGenerateColumns="False"
                    OnPageIndexChanging="JobList_PageIndexChanging" DataKeyNames="JobId" OnRowCancelingEdit="JobList_RowCancelingEdit"
                    OnRowEditing="JobList_RowEditing" OnRowUpdating="JobList_RowUpdating" PageSize="11"
                    OnRowDeleting="JobList_RowDeleting" CellPadding="0" CssClass="gv" Width="100%"
                    EmptyDataText="暂无任何职位" OnRowDataBound="JobList_RowDataBound" OnRowCommand="JobList_RowCommand">
                    <Columns>
                        <asp:BoundField DataField="JobId" HeaderText="ID">
                            <ControlStyle CssClass="gvOrderId" />
                        </asp:BoundField>
                        <asp:BoundField DataField="Title" HeaderText="职位标题" ReadOnly="True" SortExpression="Title" />
                        <asp:BoundField DataField="StartTime" HeaderText="发布日期" ReadOnly="True" SortExpression="StartTime" />
                        <asp:BoundField DataField="EndTime" HeaderText="截止日期" ReadOnly="True" SortExpression="EndTime" />
                        <asp:TemplateField HeaderText="操作" ShowHeader="False">
                            <ItemStyle CssClass="gvCommandField" />
                            <ItemTemplate>
                                <asp:Button ID="EditBt" runat="server" CausesValidation="False" CommandName="editJob"
                                    CommandArgument='<%# Eval("JobId").ToString().Trim() %>' Text="编辑" />
                                &nbsp;<asp:Button ID="DelBt" runat="server" CausesValidation="False" CommandName="Delete"
                                    Text="删除" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="添加职位">
                            <ItemStyle CssClass="gvBtAField" />
                            <ItemTemplate>
                                <asp:Button ID="AddBt" runat="server" CommandName="addJob" CommandArgument='<%# Eval("JobId").ToString().Trim() %>'
                                    Text="添加职位" CssClass="addBt" CausesValidation="False" />
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                    <RowStyle CssClass="gvRow" />
                    <EditRowStyle CssClass="gvEditRow" />
                    <PagerStyle CssClass="gvPage" />
                    <HeaderStyle CssClass="gvHeader" />
                    <AlternatingRowStyle CssClass="gvAlternatingRow" />
                </asp:GridView>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:UpdatePanel ID="JobSaveUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <table width="100%" border="0" cellpadding="2" cellspacing="1" bgcolor="#D7D7D7"
                    id="mainBottTable">
                    <tr>
                        <td colspan="2" bgcolor="#FFFFFF" class="mainTitle">
                            "<asp:Label ID="MenuName" runat="server" ForeColor="Black"></asp:Label>"<asp:Literal
                                ID="SaveType" runat="server" Text="添加"></asp:Literal>职位&nbsp;
                            <asp:HiddenField ID="EditId" runat="server" />
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF"  class="mainContentLeftTd">
                            职位名称:
                        </td>
                        <td bgcolor="#FFFFFF">
                            <asp:TextBox ID="JobTitle" runat="server"></asp:TextBox>
                            <span class="explain">在职位详情中用 $JobName$ 调用</span>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="JobTitle"
                                Display="Dynamic" ErrorMessage="职位标题必须填写"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            发布日期:
                        </td>
                        <td bgcolor="#FFFFFF">
                            <asp:TextBox ID="StartTime" runat="server"></asp:TextBox>
                            <span class="explain">在职位详情中用 $StartTime$ 调用</span>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ControlToValidate="StartTime"
                                Display="Dynamic" ErrorMessage="开始时间必须填写"></asp:RequiredFieldValidator>&nbsp;
                            <asp:CustomValidator ID="CustomValidator1" runat="server" ControlToValidate="StartTime"
                                Display="Dynamic" ErrorMessage="时间格式错误！" OnServerValidate="CustomValidator1_ServerValidate"></asp:CustomValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            截止日期:
                        </td>
                        <td bgcolor="#FFFFFF">
                            <asp:TextBox ID="EndTime" runat="server"></asp:TextBox>
                            <span class="explain">在职位详情中用 $EndTime$ 调用</span>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="EndTime"
                                Display="Dynamic" ErrorMessage="结束时间必须填写"></asp:RequiredFieldValidator>&nbsp;
                            <asp:CustomValidator ID="CustomValidator2" runat="server" ControlToValidate="EndTime"
                                Display="Dynamic" ErrorMessage="时间格式错误！" OnServerValidate="CustomValidator1_ServerValidate"></asp:CustomValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            职位详情:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;
                            <span class="explain">使用 $JobName$,$StartTime$,$EndTime$ 调用以上填写的内容,不必重复填写</span>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" align="left" bgcolor="#ffffff">
                            <div class="mainNoLeftTd">
                                <FCKeditorV2:FCKeditor ID="JobContent" runat="server" Height="400px" Width="100%">
                                </FCKeditorV2:FCKeditor>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:Button ID="Save" runat="server" Text="添加职位" CssClass="inputBt" OnClick="Save_Click" />
                        </td>
                    </tr>
                </table>
            </ContentTemplate>
        </asp:UpdatePanel>
    </div>
</asp:Content>
