﻿<%@ page language="C#" masterpagefile="~/Manage/Main.master" autoeventwireup="true" inherits="manage_Notice, ShanRui.WebSite" title="公告管理" validaterequest="false" %>

<%@ Register Assembly="FredCK.FCKeditorV2" Namespace="FredCK.FCKeditorV2" TagPrefix="FCKeditorV2" %>
<asp:Content ID="Content2" ContentPlaceHolderID="MidContent" runat="Server">
    <div id="main">
        <asp:UpdatePanel ID="MsgUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:Label ID="Msg" runat="server" Text="" CssClass="msg" Visible="False" EnableViewState="False"></asp:Label>
            </ContentTemplate>
        </asp:UpdatePanel>
        <table width="100%" border="0" cellpadding="2" cellspacing="1" bgcolor="#D7D7D7"
            id="mainTopTable">
            <tr>
                <td colspan="3" bgcolor="#FFFFFF" class="mainTitle">
                    公告检索&nbsp;
                </td>
            </tr>
            <tr>
                <td bgcolor="#FFFFFF" align="right">
                    公告标题/内容:
                </td>
                <td bgcolor="#FFFFFF">
                    &nbsp;<asp:TextBox ID="NoticeTitleKey" runat="server" CssClass="inputText"></asp:TextBox>
                    <asp:HiddenField ID="IsSearch" runat="server" Value="0" />
                </td>
                <td bgcolor="#ffffff">
                    <asp:Button ID="SearchBt" runat="server" CssClass="inputBt" Text="公告检索" OnClick="Search_Click"
                        ValidationGroup="NoticeSearch" />
                </td>
            </tr>
        </table>
        <asp:UpdatePanel ID="NoticeListUpdatePanel" UpdateMode="Conditional" runat="server">
            <Triggers>
                <asp:AsyncPostBackTrigger ControlID="SearchBt" />
            </Triggers>
            <ContentTemplate>
                <asp:GridView ID="NoticeList" runat="server" AllowPaging="True" AutoGenerateColumns="False"
                    OnPageIndexChanging="NoticeList_PageIndexChanging" DataKeyNames="NoticeId" OnRowCancelingEdit="NoticeList_RowCancelingEdit"
                    OnRowEditing="NoticeList_RowEditing" OnRowUpdating="NoticeList_RowUpdating" PageSize="11"
                    OnRowDeleting="NoticeList_RowDeleting" CellPadding="0" CssClass="gv" Width="100%"
                    EmptyDataText="暂无任何公告" OnRowDataBound="NoticeList_RowDataBound" OnRowCommand="NoticeList_RowCommand">
                    <Columns>
                        <asp:BoundField DataField="NoticeId" HeaderText="ID">
                            <ControlStyle CssClass="gvOrderId" />
                        </asp:BoundField>
                        <asp:BoundField DataField="Title" HeaderText="公告标题" ReadOnly="True" SortExpression="Title" />
                        <asp:BoundField DataField="AddTime" HeaderText="添加时间" ReadOnly="True" SortExpression="AddTime" />
                        <asp:TemplateField HeaderText="操作" ShowHeader="False">
                            <ItemStyle CssClass="gvCommandField" />
                            <ItemTemplate>
                                <asp:Button ID="EditBt" runat="server" CausesValidation="False" CommandName="editNotice"
                                    CommandArgument='<%# Eval("NoticeId").ToString().Trim() %>' Text="编辑" />
                                &nbsp;<asp:Button ID="DelBt" runat="server" CausesValidation="False" CommandName="Delete"
                                    Text="删除" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="添加公告">
                            <ItemStyle CssClass="gvBtAField" />
                            <ItemTemplate>
                                <asp:Button ID="AddBt" runat="server" CommandName="addNotice" CommandArgument='<%# Eval("NoticeId").ToString().Trim() %>'
                                    Text="添加公告" CssClass="addBt" CausesValidation="False" />
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                    <RowStyle CssClass="gvRow" />
                    <EditRowStyle CssClass="gvEditRow" />
                    <PagerStyle CssClass="gvPage" />
                    <HeaderStyle CssClass="gvHeader" />
                    <AlternatingRowStyle CssClass="gvAlternatingRow" />
                </asp:GridView>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:UpdatePanel ID="NoticeSaveUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <table width="100%" border="0" cellpadding="2" cellspacing="1" bgcolor="#D7D7D7"
                    id="mainBottTable">
                    <tr>
                        <td colspan="2" bgcolor="#FFFFFF" class="mainTitle">
                            <asp:Literal ID="SaveType" runat="server" Text="添加"></asp:Literal>公告&nbsp;
                            <asp:HiddenField ID="EditId" runat="server" />
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF" class="mainContentLeftTd">
                            公告标题:
                        </td>
                        <td bgcolor="#FFFFFF" class="mainContentRightTd">
                            <asp:TextBox ID="NoticeTitle" runat="server"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="NoticeTitle"
                                Display="Dynamic" ErrorMessage="公告标题必须填写"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            添加时间:
                        </td>
                        <td bgcolor="#FFFFFF">
                            <asp:TextBox ID="AddTime" runat="server"></asp:TextBox>
                            &nbsp;&nbsp;
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="AddTime"
                                Display="Dynamic" ErrorMessage="添加时间必须填写"></asp:RequiredFieldValidator>
                            <asp:CustomValidator ID="CustomValidator1" runat="server" ControlToValidate="AddTime"
                                ErrorMessage="时间格式错误" OnServerValidate="CustomValidator1_ServerValidate1"></asp:CustomValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            公告内容:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" align="left" bgcolor="#ffffff">
                            <div class="mainNoLeftTd">
                                <FCKeditorV2:FCKeditor ID="NoticeContent" runat="server" Height="400px" Width="100%">
                                </FCKeditorV2:FCKeditor>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:Button ID="Save" runat="server" Text="添加公告" CssClass="inputBt" OnClick="Save_Click" />
                        </td>
                    </tr>
                </table>
            </ContentTemplate>
        </asp:UpdatePanel>
    </div>
</asp:Content>
