﻿<%@ page language="C#" masterpagefile="~/Manage/Main.master" autoeventwireup="true" inherits="manage_PaymentConfig, ShanRui.WebSite" title="支付方式列表" validaterequest="false" %>

<%@ Register Assembly="FredCK.FCKeditorV2" Namespace="FredCK.FCKeditorV2" TagPrefix="FCKeditorV2" %>
<asp:Content ID="Content2" ContentPlaceHolderID="MidContent" runat="Server">
    <div id="main">
        <asp:UpdatePanel ID="MsgUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:Label ID="Msg" runat="server" Text="" CssClass="msg" Visible="False" EnableViewState="False"></asp:Label>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:UpdatePanel ID="PaymentListUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:GridView ID="PaymentList" runat="server" AllowPaging="True" AutoGenerateColumns="False"
                    OnPageIndexChanging="PaymentList_PageIndexChanging" DataKeyNames="PaymentId"
                    PageSize="11" OnRowDeleting="PaymentList_RowDeleting" CellPadding="0" CssClass="gv"
                    Width="100%" EmptyDataText="暂无任何支付方式" OnRowCommand="PaymentList_RowCommand">
                    <Columns>
                        <asp:BoundField DataField="PaymentId" HeaderText="ID">
                            <ControlStyle CssClass="gvOrderId" />
                        </asp:BoundField>
                        <asp:BoundField DataField="PaymentName" HeaderText="支付方式名称" ReadOnly="True" />
                        <asp:TemplateField HeaderText="操作" ShowHeader="False">
                            <EditItemTemplate>
                                &nbsp;
                            </EditItemTemplate>
                            <ItemStyle CssClass="gvCommandField" />
                            <ItemTemplate>
                                <asp:Button ID="EditBt" runat="server" CausesValidation="False" CommandName="editPayment"
                                    CommandArgument='<%# Eval("PaymentId").ToString().Trim() %>' Text="编辑" />
                                &nbsp;<asp:Button ID="DelBt" runat="server" CausesValidation="False" CommandName="Delete"
                                    Text="删除" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="添加支付方式">
                            <ItemStyle CssClass="gvBtAField" />
                            <ItemTemplate>
                                <asp:Button ID="AddBt" runat="server" CommandName="addPayment" CommandArgument='<%# Eval("PaymentId").ToString().Trim() %>'
                                    Text="添加支付." CssClass="addBt" CausesValidation="False" />
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                    <RowStyle CssClass="gvRow" />
                    <EditRowStyle CssClass="gvEditRow" />
                    <PagerStyle CssClass="gvPage" />
                    <HeaderStyle CssClass="gvHeader" />
                    <AlternatingRowStyle CssClass="gvAlternatingRow" />
                </asp:GridView>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:UpdatePanel ID="PaymentSaveUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <table width="100%" border="0" cellpadding="2" cellspacing="1" bgcolor="#D7D7D7"
                    id="mainBottTable">
                    <tr>
                        <td colspan="2" bgcolor="#FFFFFF" class="mainTitle">
                            <asp:Literal ID="SaveType" runat="server" Text="添加"></asp:Literal>支付方式<asp:HiddenField
                                ID="EditId" runat="server" />
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF" class="mainContentLeftTd">
                            支付方式名称:
                        </td>
                        <td bgcolor="#FFFFFF" class="mainContentRightTd">
                            <asp:TextBox ID="PaymentName" runat="server"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="PaymentName"
                                Display="Dynamic" ErrorMessage="支付方式名称必须填写"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            支付方式介绍:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" align="left" bgcolor="#ffffff">
                            <div class="mainNoLeftTd">
                                <FCKeditorV2:FCKeditor ID="PaymentContent" runat="server" Height="400px" Width="100%">
                                </FCKeditorV2:FCKeditor>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:Button ID="Save" runat="server" Text="添加支付" CssClass="inputBt" OnClick="Save_Click" />
                        </td>
                    </tr>
                </table>
            </ContentTemplate>
        </asp:UpdatePanel>
    </div>
</asp:Content>
