﻿<%@ page language="C#" masterpagefile="~/Manage/Main.master" autoeventwireup="true" inherits="manage_ProductList, ShanRui.WebSite" validaterequest="false" title="产品管理" %>

<%@ Register Assembly="FredCK.FCKeditorV2" Namespace="FredCK.FCKeditorV2" TagPrefix="FCKeditorV2" %>
<asp:Content ID="Content2" ContentPlaceHolderID="MidContent" runat="Server">
    <div id="main">
        <asp:UpdatePanel ID="MsgUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:Label ID="Msg" runat="server" Text="" CssClass="msg" Visible="False" EnableViewState="False"></asp:Label>
            </ContentTemplate>
        </asp:UpdatePanel>
        <table width="100%" border="0" cellpadding="2" cellspacing="1" bgcolor="#D7D7D7"
            id="mainTopTable">
            <tr>
                <td colspan="5" bgcolor="#FFFFFF" class="mainTitle">
                    "<asp:Label ID="SearchMenuName" runat="server" ForeColor="Black"></asp:Label>" 产品检索&nbsp;
                </td>
            </tr>
            <tr>
                <td align="right" bgcolor="#FFFFFF">
                    属于分类:
                </td>
                <td bgcolor="#ffffff">
                    <asp:DropDownList ID="SearchClassList" runat="server">
                    </asp:DropDownList>
                </td>
                <td bgcolor="#FFFFFF" align="right">
                    产品名称/型号/摘要/介绍:
                </td>
                <td bgcolor="#FFFFFF">
                    &nbsp;<asp:TextBox ID="SearchKey" runat="server" CssClass="inputText"></asp:TextBox>
                    <asp:HiddenField ID="IsSearch" runat="server" Value="0" />
                </td>
                <td bgcolor="#ffffff">
                    <asp:Button ID="SearchBt" runat="server" CssClass="inputBt" Text="产品检索" OnClick="Search_Click"
                        ValidationGroup="ProductSearch" />
                </td>
            </tr>
        </table>
        <asp:UpdatePanel ID="ProductListUpdatePanel" UpdateMode="Conditional" runat="server">
            <Triggers>
                <asp:AsyncPostBackTrigger ControlID="SearchBt" />
            </Triggers>
            <ContentTemplate>
                <asp:GridView ID="ProductList" runat="server" AllowPaging="True" AutoGenerateColumns="False"
                    OnPageIndexChanging="ProductList_PageIndexChanging" DataKeyNames="ProductId,ProductClassId"
                    OnRowCancelingEdit="ProductList_RowCancelingEdit" OnRowEditing="ProductList_RowEditing"
                    OnRowUpdating="ProductList_RowUpdating" PageSize="11" OnRowDeleting="ProductList_RowDeleting"
                    CellPadding="0" CssClass="gv" Width="100%" EmptyDataText="暂无任何产品" OnRowDataBound="ProductList_RowDataBound"
                    OnRowCommand="ProductList_RowCommand">
                    <Columns>
                        <asp:BoundField DataField="ProductId" HeaderText="ID">
                            <ControlStyle CssClass="gvOrderId" />
                        </asp:BoundField>
                        <asp:BoundField DataField="ClassName" HeaderText="所属分类" ReadOnly="True" SortExpression="ClassName" />
                        <asp:BoundField DataField="ProductName" HeaderText="产品名称" ReadOnly="True" SortExpression="Title" />
                        <asp:HyperLinkField DataNavigateUrlFields="PicPathSmall" HeaderText="小图预览" Target="_blank"
                            Text="小图预览" />
                        <asp:HyperLinkField DataNavigateUrlFields="PicPathBig" HeaderText="大图预览" Text="大图预览"
                            Target="_blank" />
                        <asp:BoundField DataField="AddTime" HeaderText="添加时间" ReadOnly="True" SortExpression="AddTime" />
                        <asp:TemplateField HeaderText="操作" ShowHeader="False">
                            <ItemStyle CssClass="gvCommandField" />
                            <ItemTemplate>
                                <asp:Button ID="EditBt" runat="server" CausesValidation="False" CommandName="editProduct"
                                    CommandArgument='<%# Eval("ProductId").ToString().Trim() %>' Text="编辑" />
                                <asp:Button ID="DelBt" runat="server" CausesValidation="False" CommandName="Delete"
                                    Text="删除" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="添加产品">
                            <ItemStyle CssClass="gvBtAField" />
                            <ItemTemplate>
                                <asp:Button ID="AddBt" runat="server" CommandName="addProduct" CommandArgument='<%# Eval("ProductId").ToString().Trim() %>'
                                    Text="添加产品" CssClass="addBt" CausesValidation="False" />
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                    <RowStyle CssClass="gvRow" />
                    <EditRowStyle CssClass="gvEditRow" />
                    <PagerStyle CssClass="gvPage" />
                    <HeaderStyle CssClass="gvHeader" />
                    <AlternatingRowStyle CssClass="gvAlternatingRow" />
                </asp:GridView>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:UpdatePanel ID="ProductSaveUpdatePanel" UpdateMode="Conditional" runat="server"
            OnInit="ProductSaveUpdatePanel_Init">
            <ContentTemplate>
                <table width="100%" border="0" cellpadding="2" cellspacing="1" bgcolor="#D7D7D7"
                    id="mainBottTable">
                    <tr>
                        <td colspan="2" bgcolor="#FFFFFF" class="mainTitle">
                            "<asp:Label ID="MenuName" runat="server" ForeColor="Black"></asp:Label>"
                            <asp:Literal ID="SaveType" runat="server" Text="添加"></asp:Literal>产品
                            <asp:HiddenField ID="EditId" runat="server" />
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF" class="mainContentLeftTd">
                            所属分类:
                        </td>
                        <td bgcolor="#FFFFFF" class="mainContentRightTd">
                            <asp:DropDownList ID="ProductClassList" runat="server">
                            </asp:DropDownList>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            产品名称:
                        </td>
                        <td bgcolor="#FFFFFF">
                            <asp:TextBox ID="ProductName" runat="server"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="ProductName"
                                Display="Dynamic" ErrorMessage="产品名称必须填写"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            产品编号/型号:
                        </td>
                        <td bgcolor="#FFFFFF">
                            <asp:TextBox ID="ProductNumber" runat="server"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator5" runat="server" ControlToValidate="ProductNumber"
                                Display="Dynamic" ErrorMessage="产品编号/型号必须填写"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            产品价格:
                        </td>
                        <td bgcolor="#FFFFFF">
                            <asp:TextBox ID="Price" runat="server"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator6" runat="server" ControlToValidate="price"
                                Display="Dynamic" ErrorMessage="产品价格必须填写"></asp:RequiredFieldValidator>
                            <asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" ControlToValidate="price"
                                Display="Dynamic" ErrorMessage="价格必须为数字" ValidationExpression="[\d.]+"></asp:RegularExpressionValidator>
                        </td>
                    </tr>
                    <tr id="attributeTr0">
                        <td align="right" bgcolor="#FFFFFF">
                            <asp:Label ID="AttributeName0" runat="server"></asp:Label>:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:TextBox ID="Attribute0" runat="server"></asp:TextBox>
                            <asp:HiddenField ID="AttributeNum" runat="server" />
                            <asp:CustomValidator ID="AttributeValidator" runat="server" OnServerValidate="AttributeValidator_ServerValidate"></asp:CustomValidator>
                        </td>
                    </tr>
                    <tr id="attributeTr1">
                        <td align="right" bgcolor="#FFFFFF">
                            <asp:Label ID="AttributeName1" runat="server"></asp:Label>:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:TextBox ID="Attribute1" runat="server"></asp:TextBox>
                        </td>
                    </tr>
                    <tr id="attributeTr2">
                        <td align="right" bgcolor="#FFFFFF">
                            <asp:Label ID="AttributeName2" runat="server"></asp:Label>:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:TextBox ID="Attribute2" runat="server"></asp:TextBox>
                        </td>
                    </tr>
                    <tr id="attributeTr3">
                        <td align="right" bgcolor="#FFFFFF">
                            <asp:Label ID="AttributeName3" runat="server"></asp:Label>:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:TextBox ID="Attribute3" runat="server"></asp:TextBox>
                        </td>
                    </tr>
                    <tr id="attributeTr4">
                        <td align="right" bgcolor="#FFFFFF">
                            <asp:Label ID="AttributeName4" runat="server"></asp:Label>:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:TextBox ID="Attribute4" runat="server"></asp:TextBox>
                        </td>
                    </tr>
                    <tr id="attributeTr5">
                        <td align="right" bgcolor="#FFFFFF">
                            <asp:Label ID="AttributeName5" runat="server"></asp:Label>:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:TextBox ID="Attribute5" runat="server"></asp:TextBox>
                        </td>
                    </tr>
                    <tr id="attributeTr6">
                        <td align="right" bgcolor="#FFFFFF">
                            <asp:Label ID="AttributeName6" runat="server"></asp:Label>:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:TextBox ID="Attribute6" runat="server"></asp:TextBox>
                        </td>
                    </tr>
                    <tr id="attributeTr7">
                        <td align="right" bgcolor="#FFFFFF">
                            <asp:Label ID="AttributeName7" runat="server"></asp:Label>:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:TextBox ID="Attribute7" runat="server"></asp:TextBox>
                        </td>
                    </tr>
                    <tr id="attributeTr8">
                        <td align="right" bgcolor="#FFFFFF">
                            <asp:Label ID="AttributeName8" runat="server"></asp:Label>:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:TextBox ID="Attribute8" runat="server"></asp:TextBox>
                        </td>
                    </tr>
                    <tr id="attributeTr9">
                        <td align="right" bgcolor="#FFFFFF">
                            <asp:Label ID="AttributeName9" runat="server"></asp:Label>:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:TextBox ID="Attribute9" runat="server"></asp:TextBox>
                        </td>
                    </tr>
                    <tr id="attributeTr10">
                        <td align="right" bgcolor="#FFFFFF">
                            <asp:Label ID="AttributeName10" runat="server"></asp:Label>:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:TextBox ID="Attribute10" runat="server"></asp:TextBox>
                        </td>
                    </tr>
                    <tr id="attributeTr11">
                        <td align="right" bgcolor="#FFFFFF">
                            <asp:Label ID="AttributeName11" runat="server"></asp:Label>:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:TextBox ID="Attribute11" runat="server"></asp:TextBox>
                        </td>
                    </tr>
                    <tr id="attributeTr12">
                        <td align="right" bgcolor="#FFFFFF">
                            <asp:Label ID="AttributeName12" runat="server"></asp:Label>:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:TextBox ID="Attribute12" runat="server"></asp:TextBox>
                        </td>
                    </tr>
                    <tr id="attributeTr13">
                        <td align="right" bgcolor="#FFFFFF">
                            <asp:Label ID="AttributeName13" runat="server"></asp:Label>:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:TextBox ID="Attribute13" runat="server"></asp:TextBox>
                        </td>
                    </tr>
                    <tr id="attributeTr14">
                        <td align="right" bgcolor="#FFFFFF" style="height: 20px">
                            <asp:Label ID="AttributeName14" runat="server"></asp:Label>:
                        </td>
                        <td bgcolor="#FFFFFF" style="height: 20px">
                            &nbsp;<asp:TextBox ID="Attribute14" runat="server"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            产品小图:
                        </td>
                        <td bgcolor="#FFFFFF" id="PicSmallTd">
                            <asp:HyperLink ID="PicSmallHyperLink" runat="server" Target="_blank" Visible="false">预览原图</asp:HyperLink>
                            <span class="explain" id="PicSmallEditSpan" runat="server" visible="false">不修改请留空</span>
                            <asp:HiddenField ID="PicSmall" runat="server" Value="无" EnableViewState="false" />
                            <iframe height="24" width="550" frameborder="0" scrolling="no" src="UpLoad.aspx?type=Small&menuId=<%=ShanRui.Web.ManageSiteInfo.GetMenuId() %>">
                            </iframe>
                            &nbsp;
                            <asp:CustomValidator ID="PicSmallCustomValidator" runat="server" Display="Dynamic"
                                ErrorMessage="小图路径必须选择" ClientValidationFunction="ValidationPicSmall"></asp:CustomValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            产品大图:
                        </td>
                        <td bgcolor="#FFFFFF" id="PicBigTd">
                            <asp:HyperLink ID="PicBigHyperLink" runat="server" Target="_blank" Visible="false">预览原图</asp:HyperLink>
                            <span class="explain" id="PicBigEditSpan" runat="server" visible="false">不修改请留空</span>
                            <asp:HiddenField ID="PicBig" runat="server" Value="无" EnableViewState="false" />
                            <iframe height="24" width="550" frameborder="0" scrolling="no" src="UpLoad.aspx?type=Big&menuId=<%=ShanRui.Web.ManageSiteInfo.GetMenuId() %>">
                            </iframe>
                            &nbsp;
                            <asp:CustomValidator ID="PicBigCustomValidator" runat="server" ClientValidationFunction="ValidationPicBig"
                                Display="Dynamic" ErrorMessage="大图路径必须选择"></asp:CustomValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            添加时间:
                        </td>
                        <td bgcolor="#FFFFFF">
                            <asp:TextBox ID="AddTime" runat="server"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ControlToValidate="AddTime"
                                Display="Dynamic" ErrorMessage="添加时间必须填写"></asp:RequiredFieldValidator>&nbsp;
                            <asp:CustomValidator ID="TimeCustomValidator" runat="server" ControlToValidate="AddTime"
                                Display="Dynamic" ErrorMessage="时间格式错误！" OnServerValidate="TimeCustomValidator_ServerValidate"></asp:CustomValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            产品介绍摘要:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:TextBox ID="ProductShortContent" runat="server" Rows="4" TextMode="MultiLine"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            产品介绍:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" align="left" bgcolor="#ffffff">
                            <div class="mainNoLeftTd">
                                <FCKeditorV2:FCKeditor ID="ProductContent" runat="server" Height="400px" Width="100%">
                                </FCKeditorV2:FCKeditor>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:Button ID="Save" runat="server" Text="添加产品" CssClass="inputBt" OnClick="Save_Click" />
                        </td>
                    </tr>
                </table>
            </ContentTemplate>
        </asp:UpdatePanel>
    </div>

    <script language="JavaScript" type="text/javascript">
        attributeTrLabelShow(); //初始化自定义属性显示
    </script>

</asp:Content>
