﻿<%@ page language="C#" masterpagefile="~/Manage/Main.master" autoeventwireup="true" inherits="manage_ResumeList, ShanRui.WebSite" title="简历列表" validaterequest="false" %>

<%@ Register Assembly="FredCK.FCKeditorV2" Namespace="FredCK.FCKeditorV2" TagPrefix="FCKeditorV2" %>
<asp:Content ID="Content2" ContentPlaceHolderID="MidContent" runat="Server">
    <div id="main">
        <asp:UpdatePanel ID="MsgUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:Label ID="Msg" runat="server" Text="" CssClass="msg" Visible="False" EnableViewState="False"></asp:Label>
            </ContentTemplate>
        </asp:UpdatePanel>
        <table width="100%" border="0" cellpadding="2" cellspacing="1" bgcolor="#D7D7D7"
            id="mainTopTable">
            <tr>
                <td bgcolor="#ffffff" class="mainTitle" colspan="3">
                    "<asp:Label ID="MenuName" runat="server" ForeColor="Black"></asp:Label>" 简历检索&nbsp;
                </td>
            </tr>
            <tr>
                <td bgcolor="#FFFFFF" align="right">
                    职位名称/简历内容/简历备注:
                </td>
                <td bgcolor="#FFFFFF">
                    &nbsp;<asp:TextBox ID="ResumeTitleKey" runat="server" CssClass="inputText"></asp:TextBox>
                    <asp:HiddenField ID="IsSearch" runat="server" Value="0" />
                </td>
                <td bgcolor="#ffffff">
                    <asp:Button ID="SearchBt" runat="server" CssClass="inputBt" Text="简历检索" OnClick="Search_Click"
                        ValidationGroup="ResumeSearch" />
                </td>
            </tr>
        </table>
        <asp:UpdatePanel ID="ResumeListUpdatePanel" UpdateMode="Conditional" runat="server">
            <Triggers>
                <asp:AsyncPostBackTrigger ControlID="SearchBt" />
            </Triggers>
            <ContentTemplate>
                <asp:GridView ID="ResumeList" runat="server" AllowPaging="True" AutoGenerateColumns="False"
                    OnPageIndexChanging="ResumeList_PageIndexChanging" DataKeyNames="ResumeId" OnRowCancelingEdit="ResumeList_RowCancelingEdit"
                    OnRowEditing="ResumeList_RowEditing" OnRowUpdating="ResumeList_RowUpdating" PageSize="11"
                    OnRowDeleting="ResumeList_RowDeleting" CellPadding="0" CssClass="gv" Width="100%"
                    EmptyDataText="暂无任何简历" OnRowDataBound="ResumeList_RowDataBound" OnRowCommand="ResumeList_RowCommand">
                    <Columns>
                        <asp:BoundField DataField="ResumeId" HeaderText="ID">
                            <ControlStyle CssClass="gvOrderId" />
                        </asp:BoundField>
                        <asp:BoundField DataField="JobTitle" HeaderText="职位名称" ReadOnly="True" SortExpression="Title" />
                        <asp:BoundField DataField="AddTime" HeaderText="提交时间" ReadOnly="True" SortExpression="AddTime" />
                        <asp:BoundField DataField="FullName" HeaderText="姓名" ReadOnly="True" />
                        <asp:TemplateField HeaderText="操作" ShowHeader="False">
                            <EditItemTemplate>
                                &nbsp;
                            </EditItemTemplate>
                            <ItemStyle CssClass="gvCommandField" />
                            <ItemTemplate>
                                &nbsp;
                                <asp:Button ID="EditBt" runat="server" CommandName="editResume" CommandArgument='<%# Eval("ResumeId").ToString().Trim() %>'
                                    Text="查看" CssClass="addBt" CausesValidation="False" />
                                <asp:Button ID="DelBt" runat="server" CausesValidation="False" CommandName="Delete"
                                    Text="删除" />
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                    <RowStyle CssClass="gvRow" />
                    <EditRowStyle CssClass="gvEditRow" />
                    <PagerStyle CssClass="gvPage" />
                    <HeaderStyle CssClass="gvHeader" />
                    <AlternatingRowStyle CssClass="gvAlternatingRow" />
                </asp:GridView>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:UpdatePanel ID="ResumeSaveUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:Panel ID="ResumeEditPanel" runat="server" CssClass="hide">
                    <asp:HiddenField ID="EditId" runat="server" />
                    <table width="100%" border="0" cellpadding="2" cellspacing="1" bgcolor="#D7D7D7"
                        id="mainBottTable">
                        <tr>
                            <td colspan="2" bgcolor="#FFFFFF" class="mainTitle">
                                "<asp:Label ID="MenuName1" runat="server" ForeColor="Black"></asp:Label>" 查看简历&nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#FFFFFF" class="mainContentLeftTd">
                                简历ID:
                            </td>
                            <td bgcolor="#FFFFFF" class="mainContentRightTd">
                                <asp:Label ID="ShowResumeId" runat="server" ForeColor="Red"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#FFFFFF">
                                职位名称:
                            </td>
                            <td bgcolor="#FFFFFF">
                                &nbsp;<asp:Label ID="JobTitle" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#ffffff">
                                姓名:
                            </td>
                            <td bgcolor="#ffffff">
                                &nbsp;<asp:Label ID="FullName" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#FFFFFF">
                                提交时间:
                            </td>
                            <td bgcolor="#FFFFFF">
                                &nbsp;<asp:Label ID="AddTime" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#FFFFFF">
                                简历内容
                            </td>
                            <td bgcolor="#FFFFFF">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2" align="left" bgcolor="#ffffff">
                                <div class="mainNoLeftTd">
                                    <FCKeditorV2:FCKeditor ID="ResumeContent" runat="server" Height="400px" Width="100%"
                                        ToolbarStartExpanded="false" ToolbarCanCollapse="true">
                                    </FCKeditorV2:FCKeditor>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#FFFFFF">
                                备注:
                            </td>
                            <td bgcolor="#FFFFFF">
                                &nbsp;<asp:TextBox ID="Remark" runat="server" Rows="6" TextMode="MultiLine"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" bgcolor="#FFFFFF">
                            </td>
                            <td bgcolor="#FFFFFF">
                                &nbsp;<asp:Button ID="Edit" runat="server" Text="提交备注" CssClass="inputBt" OnClick="Edit_Click" />
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
            </ContentTemplate>
        </asp:UpdatePanel>
    </div>
</asp:Content>
