﻿<%@ page language="C#" masterpagefile="~/Master/Default/Page.master" autoeventwireup="true" inherits="Product, ShanRui.WebSite" title="Untitled Page" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>

<asp:Content ID="SideContent" ContentPlaceHolderID="Side" Runat="Server">
    <div class="sideMenu">
        <shanRui:SideMenu ID="PageSideMenu" runat="server" />
    </div>
    <shanRui:GoodCountBox ID="myGoodCountBox" runat="server" />
</asp:Content>
<asp:Content ID="MainContent" ContentPlaceHolderID="MainContent" Runat="Server">
    <div class="siteMapPath" >
        <asp:Literal ID="SiteMapPath" runat="server" EnableViewState="False"></asp:Literal>
    </div>
    <div class="pageMainContent">
        <asp:Panel ID="NoLoginPanel" runat="server" Visible="false" EnableViewState="False">
            <asp:Label ID="PlealseLogin" runat="server" CssClass="plealseLogin" Text="" ></asp:Label>
            <shanRui:MemberLogin ID="MemberLogin1" runat="server" EnableViewState="false" />
        </asp:Panel>
        <asp:Panel ID="LoginPanel" runat="server" EnableViewState="False">
            <h2><asp:Literal ID="PageMainContentTitle" runat="server" EnableViewState="False"></asp:Literal></h2>
            <asp:DataList ID="ProductList" runat="server" EnableViewState="False" CssClass="productList"  RepeatDirection="Horizontal" >
                <HeaderTemplate>
                    <asp:Label ID="ProductListTitle" runat="server" CssClass="productListTitle"></asp:Label>
                </HeaderTemplate>
                <ItemTemplate>
                    <a href='<%# ShanRui.Web.Website.IsURLRewriter() ? String.Format("{1}-D3_{0}_{2}.{3}",Eval("ProductId").ToString(),Eval("FileName").ToString(),ShanRui.Web.Website.GetLanguage(),ShanRui.Web.Website.HTMLExtension()) : String.Format("ProductDetail.aspx?id={0}&fileName={1}&Language={2}",Eval("ProductId").ToString(),Eval("FileName").ToString(),ShanRui.Web.Website.GetLanguage()) %>'><asp:Image ID="SmallImage" CssClass="productImage" Width="<%# new Unit(_width)%>" Height="<%# new Unit(_height)%>"  runat="server" ImageUrl='<%# Bind("PicPathSmall") %>' AlternateText='<%# Bind("ProductName") %>' /></a>
                    <div class="productText">
                        <div class="productNameBox">
                            <asp:Label ID="ClassName" CssClass="productClassName" runat="server" Text='<%# String.Format("[{0}]",Eval("ClassName").ToString()) %>'></asp:Label>
                            <asp:HyperLink ID="ProductName" CssClass="productName" runat="server" NavigateUrl='<%# ShanRui.Web.Website.IsURLRewriter() ? String.Format("{1}-D3_{0}_{2}.{3}",Eval("ProductId").ToString(),Eval("FileName").ToString(),ShanRui.Web.Website.GetLanguage(),ShanRui.Web.Website.HTMLExtension()) : String.Format("~/ProductDetail.aspx?id={0}&fileName={1}&Language={2}",Eval("ProductId").ToString(),Eval("FileName").ToString(),ShanRui.Web.Website.GetLanguage()) %>' Text='<%# ShanRui.Web.Strings.CutLenStr(Eval("ProductName").ToString(),_titleLength) %>' ToolTip='<%# Eval("ProductName") %>'></asp:HyperLink>
                        </div>
                        <div  class="productNumberBox">
                            <asp:Label ID="ProductNumberLabel" meta:resourcekey="ProductNumberLabel" CssClass="productNumberLabel" EnableViewState="False" runat="server" Text=""></asp:Label>
                            <asp:Label ID="ProductNumber" runat="server" Text='<%# Eval("ProductNumber") %>' CssClass="productNumber" ></asp:Label>
                        </div>
                        <div  class="priceBox">
                            <asp:Label ID="PriceLabel" meta:resourcekey="PriceLabel" CssClass="priceLabel" EnableViewState="False" runat="server" Text=""></asp:Label>
                            <asp:Label ID="Price" runat="server" Text='<%# _moneyUnit+Convert.ToSingle(Eval("Price")).ToString(".00") %>' CssClass="price"></asp:Label>
                        </div>
                        <div class="productShortContentBox">
                            <asp:Label ID="ProductShortContent" CssClass="productShortContent" runat="server" Text='<%# ShanRui.Web.Strings.CutLenStr(Eval("ProductShortContent").ToString(),_shortContentLength) %>'></asp:Label>
                        </div>
                        <div class="cartButtonBox">
                            <asp:Button ID="CartButton" OnClientClick='<%# String.Format("return CartOpen({0},{1});",Eval("ProductId").ToString(),ShanRui.Web.Website.GetLanguage()) %>'  meta:resourcekey="CartButton" CssClass="cartButton" runat="server" EnableViewState="False" CausesValidation="False" UseSubmitBehavior="False" />
                        </div>
                    </div>
                </ItemTemplate>
                <ItemStyle Font-Bold="False" Font-Italic="False" Font-Overline="False" Font-Strikeout="False"
            Font-Underline="False" CssClass="productItem" />
                <AlternatingItemStyle CssClass="productAlternating" />
                <SeparatorStyle CssClass="productSeparator" />
                <HeaderStyle CssClass="productHeader" />
            </asp:DataList>
            <div class="pageMenu">
                <webdiyer:AspNetPager ID="ProductListPager" runat="server" AlwaysShow="True" UrlPaging="true" EnableUrlRewriting="false" OnPageChanged="ProductListPager_PageChanged" ShowBoxThreshold="20" EnableViewState="False" InputBoxClass="pagerInputBox" OnPageChanging="ProductListPager_PageChanging" SubmitButtonClass="pagerSubmitButton" CurrentPageButtonClass="pagerCurrentPageButton">
                </webdiyer:AspNetPager>
            </div>
        </asp:Panel>
    </div>
</asp:Content>
