﻿// -----------------------------------------------------------------------
// <copyright file="AdminBll.cs" project="EnterpriseWeb.Bll" ver="1.0">
//   Copyright 2009 - 2009 - JRJJ. All rights reserved.
// </copyright>
// -----------------------------------------------------------------------



using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using EnterpriseWeb.Dal;
using EnterpriseWeb.Model;

namespace EnterpriseWeb.Bll
{
    /// <summary>
    /// Admin Bll .
    /// </summary>
    
    [DataObjectAttribute()]
    public static class AdminBll
    {
        #region Public Methods

        /// <summary>查询所有管理员记录.</summary>
        /// <returns>管理员记录 list</returns>
        [DataObjectMethod(DataObjectMethodType.Select, true)]
        public static AdminCollection GetList()
        {
            return AdminDal.GetList();
        }

        /// <summary> 条件查询一条管理员记录.</summary>
        /// <param name="username">管理员用户名</param>
        /// <param name="password">管理员密码</param>
        /// <returns>管理员记录 admin模型</returns>
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static Admin GetItem(string username, string password)
        {
            Admin myAdmin = new Admin();
            myAdmin.username = username;
            myAdmin.password = password;
            return AdminDal.GetItem(myAdmin);
        }

        /// <summary> 条件查询一条管理员记录.</summary>
        /// <param name="username">管理员用户名</param>
        /// <returns>管理员记录 admin模型</returns>
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static Admin GetItem(string username)
        {
            Admin myAdmin = new Admin();
            myAdmin.username = username;
            return AdminDal.GetItem(myAdmin);
        }

        /// <summary> 条件查询一条管理员记录.</summary>
        /// <param name="admin_id">管理员用户ID</param>
        /// <returns>管理员记录 admin模型</returns>
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static Admin GetItem(int admin_id)
        {
            Admin myAdmin = new Admin();
            myAdmin.admin_id = admin_id;
            return AdminDal.GetItem(myAdmin);
        }

        /// <summary>删除一条管理员记录</summary>
        /// <param name="id">管理员ID</param>
        /// <returns>返回 <c>true</c> 删除成功, 或 <c>false</c> 删除失败.</returns>
        [DataObjectMethod(DataObjectMethodType.Delete, true)]
        public static bool Delete(int admin_id)
        {
            return AdminDal.Delete(admin_id);
        }


        /// <summary>修改管理员密码</summary>
        /// <param name="id">管理员ID</param>
        /// <param name="password">管理员密码</param>
        /// <returns>返回 <c>true</c> 修改成功, 或 <c>false</c> 修改失败.</returns>
        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Update(int admin_id, string password)
        {
            Admin myAdmin = new Admin();
            myAdmin.admin_id = admin_id;
            myAdmin.password = password;
            return AdminDal.Update(myAdmin);
        }


        /// <summary>修改管理员登录IP和时间</summary>
        /// <param name="id">管理员ID</param>
        /// <param name="loginip">管理员登录IP</param>
        /// <param name="logindate">管理员登录时间</param>
        /// <returns>返回 <c>true</c> 修改成功, 或 <c>false</c> 修改失败.</returns>
        [DataObjectMethod(DataObjectMethodType.Update, false)]
        public static bool Update(int admin_id, string loginip, DateTime logindate)
        {
            Admin myAdmin = new Admin();
            myAdmin.admin_id = admin_id;
            myAdmin.login_ip = loginip;
            myAdmin.login_date = logindate;
            
            return AdminDal.Update(myAdmin);
            
        }

        /// <summary>插入一条管理员记录</summary>
        /// <param name="adm">admin模型</param>
        /// <returns>返回 <c>true</c> 插入成功, 或 <c>false</c> 插入失败.</returns>
        [DataObjectMethod(DataObjectMethodType.Insert, true)]
        public static bool Insert(Admin myAdmin)
        {
            if (string.IsNullOrEmpty(myAdmin.username) || string.IsNullOrEmpty(myAdmin.password) || string.IsNullOrEmpty(myAdmin.login_ip))
            {
                return false;
            }
            else
            {
                myAdmin.joindate = DateTime.Now;
                myAdmin.login_date = DateTime.Now;
                return AdminDal.Insert(myAdmin);
            }
        }


        #endregion
    }
}
