﻿// -----------------------------------------------------------------------
// <copyright file="FeedbackBll.cs" project="EnterpriseWeb.Bll" ver="1.0">
//   Copyright 2009 - 2009 - JRJJ. All rights reserved.
// </copyright>
// -----------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using EnterpriseWeb.Dal;
using EnterpriseWeb.Model;

namespace EnterpriseWeb.Bll
{
    /// <summary>
    /// Feedbak Bll .
    /// </summary>
    /// 
    [DataObjectAttribute()]
    public static class FeedbackBll
    {
        #region Public Methods


        /// <summary>
        /// 条件查询查询所有留言记录.
		/// </summary>
		/// <returns>留言记录 list</returns>
        [DataObjectMethod(DataObjectMethodType.Select, true)]
        public static FeedbackCollection GetList(int startRowIndex, int maximumRows)
        {
            return FeedbackDal.GetList( startRowIndex, maximumRows );
        }


        /// <summary>获得 Feedback 通过审查的数据</summary>
        /// <param name="startRowIndex">起始记录</param>
        /// <param name="maximumRows">最大记录数</param>
        /// <param name="isview">是否可查看</param>
        /// <returns>FeedbackCollection 通过审查的数据.</returns>
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static FeedbackCollection GetList(int startRowIndex, int maximumRows, bool isView)
        {
            return FeedbackDal.GetList(startRowIndex, maximumRows, isView);
        }


        /// <summary>删除一条留言记录</summary>
        /// <param name="id">留言ID</param>
        /// <returns>返回 <c>true</c> 删除成功, 或 <c>false</c> 删除失败.</returns>
        [DataObjectMethod(DataObjectMethodType.Delete, true)]
        public static bool Delete(int id)
        {
            return FeedbackDal.Delete(id);
        }


        /// <summary>修改一条留言记录允许字段</summary>
        /// <param name="id">留言ID</param>
        /// <param name="isview">true=允许，false=拒绝</param>
        /// <returns>返回 <c>true</c> 修改成功, 或 <c>false</c> 修改失败.</returns>
        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Update(int id, bool isview)
        {
            return FeedbackDal.Update(id, isview);
        }

        /// <summary>插入一条留言记录</summary>
        /// <param name="fb">feedback模型</param>
        /// <returns>返回插入记录的ID , 返回0 错误</returns>
        [DataObjectMethod(DataObjectMethodType.Insert, true)]
        public static bool Insert(Feedback myFeedback)
        {
            if (string.IsNullOrEmpty(myFeedback.fb_title) || string.IsNullOrEmpty(myFeedback.fb_content))
            {
                return false;
            }
            else
            {
                return FeedbackDal.Insert(myFeedback);
            }
        }


        #endregion
    }
}
