﻿// -----------------------------------------------------------------------
// <copyright file="ProductBll.cs" project="EnterpriseWeb.Bll" ver="1.0">
//   Copyright 2009 - 2009 - JRJJ. All rights reserved.
// </copyright>
// -----------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using EnterpriseWeb.Dal;
using EnterpriseWeb.Model;


namespace EnterpriseWeb.Bll
{
    /// <summary>
    /// Product Bll .
    /// </summary>
    [DataObjectAttribute()]
    public static class ProductBll
    {
        #region Public Methods
        /// <summary>查询分类产品 带分页 所有数据.</summary>
        /// <param name="pc_id">产品分类ID</param>
        /// <param name="startRowIndex">起始记录</param>
        /// <param name="maximumRows">最多记录数</param>
        /// <returns>产品 list</returns>
        [DataObjectMethod(DataObjectMethodType.Select, true)]
        public static ProductCollection GetList(int pc_id, int startRowIndex, int maximumRows)
        {
            return ProductDal.GetList(pc_id, startRowIndex, maximumRows);
        }

        /// <summary>查询分类产品 无分页 所有数据.</summary>
        /// <param name="pc_id">产品分类ID</param>
        /// <returns>产品 list</returns>
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static ProductCollection GetList(int pc_id)
        {
            return ProductDal.GetList(pc_id, 0, 0);
        }

        /// <summary>查询分类产品 无分页 所有数据.</summary>
        /// <returns>产品 list</returns>
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static ProductCollection GetList(bool istop, bool iscommend)
        {
            return ProductDal.GetList(istop, iscommend);
        }



        /// <summary>查询产品记录.</summary>
        /// <param name="prod_id">产品ID</param>
        /// <returns>Product模型 包含一条产品记录.</returns>
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static Product GetItem(int prod_id)
        {
            return ProductDal.GetItem(prod_id);


        }

        /// <summary>删除一条产品记录</summary>
        /// <param name="prod_id">产品ID</param>
        /// <returns>返回 <c>true</c> 删除成功, 或 <c>false</c> 删除失败.</returns>
        [DataObjectMethod(DataObjectMethodType.Delete, true)]
        public static bool Delete(int prod_id)
        {
            return ProductDal.Delete(prod_id);
        }

        /// <summary>增加产品点击数</summary>
        /// <param name="prod_id">产品ID</param>
        /// <returns>返回 <c>true</c> 修改成功, 或 <c>false</c> 修改失败.</returns>
        [DataObjectMethod(DataObjectMethodType.Update, false)]
        public static bool Update(int prod_id)
        {
            return ProductDal.Update(prod_id);

        }


        /// <summary>修改产品记录</summary>
        /// <param name="myProduct">Product模型</param>
        /// <returns>返回 <c>true</c> 修改成功, 或 <c>false</c> 修改失败.</returns>
        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Update(Product myProduct)
        {
            if (myProduct.prod_id > 0
                && !string.IsNullOrEmpty(myProduct.prod_name)
                && !string.IsNullOrEmpty(myProduct.prod_content)
                && myProduct.pc_id > 0)
            {
                myProduct.prod_date = DateTime.Now;
                return ProductDal.Update(myProduct);
            }
            else
            {
                return false;
            }
        }


        /// <summary>插入产品记录</summary>
        /// <param name="myProduct">Product 模型</param>
        /// <returns>返回 <c>true</c> 插入成功, 或 <c>false</c> 插入失败.</returns>
        [DataObjectMethod(DataObjectMethodType.Insert, true)]
        public static bool Insert(Product myProduct)
        {
            if (!string.IsNullOrEmpty(myProduct.prod_name)
                && !string.IsNullOrEmpty(myProduct.prod_content)
                && myProduct.pc_id > 0)
            {
                myProduct.prod_date = DateTime.Now;
                return ProductDal.Insert(myProduct);
            }
            else
            {
                return false;
            }
        }


        #endregion 

    }
}
