﻿// -----------------------------------------------------------------------
// <copyright file="SitePropertyBll.cs" project="EnterpriseWeb.Bll" ver="1.0">
//   Copyright 2009 - 2009 - JRJJ. All rights reserved.
// </copyright>
// -----------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using EnterpriseWeb.Dal;
using EnterpriseWeb.Model;

namespace EnterpriseWeb.Bll
{
    [DataObjectAttribute()]
    public static class SitePropertyBll
    {
        #region Public Properties

        /// <summary>获得SiteProperty表数据</summary>
        /// <returns>SiteProperty模型  包含所有记录.</returns>
        [DataObjectMethod(DataObjectMethodType.Select, true)]
        public static SiteProperty GetSiteProperty()
        {
            return SitePropertyDal.GetSiteProperty();
        }


        /// <summary>修改SiteProperty表</summary>
        /// <param name="sp">sp--SiteProperty模版</param>
        /// <returns>返回 <c>true</c> 修改成功, 或 <c>false</c> 修改失败.</returns>
        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Update(SiteProperty sp)
        {
            return SitePropertyDal.Update(sp);
        }

        #endregion
    }
}
