﻿// -----------------------------------------------------------------------
// <copyright file="BaseCommon.cs" project="EnterpriseWeb.Common" ver="1.0">
//   Copyright 2009 - 2009 - JRJJ. All rights reserved.
// </copyright>
// -----------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

//５１aｓｐx
namespace EnterpriseWeb.Common
{
    /// <summary>
    /// Common 类通用方法.
    /// </summary>
    public static class BaseCommon
    {
        /// <summary> 判断字符串是否为整型 </summary> 
        /// <param name="str">字符串</param> 
        /// <returns>返回 <c>true</c> 是正整数, 或 <c>false</c> 非正整数.</returns>
        public static bool IsInt(string str)
        {   
            Regex regex = new Regex("^[0-9]*[1-9][0-9]*$");
            return regex.IsMatch(str.Trim());
        }

        /// <summary> Request.QueryString 输入参数效验 </summary> 
        /// <param name="str">字符串</param> 
        /// <returns>返回 <c>true</c> 有效的, 或 <c>false</c> 无效.</returns>
        public static bool ValidQueryString(string str)
        {
            if (string.IsNullOrEmpty(str) || str.Length > 9 || !IsInt(str))
            {
                return false;
            }
            else
            {
                return true;
            }
        }


    }


}
