﻿// -----------------------------------------------------------------------
// <copyright file="AdminDal.cs" project="EnterpriseWeb.Dal" ver="1.0">
//   Copyright 2009 - 2009 - JRJJ. All rights reserved.
// </copyright>
// -----------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using EnterpriseWeb.Model;

namespace EnterpriseWeb.Dal
{
    /// <summary>
    /// 管理员管理 Dal
    /// </summary>
    public static class AdminDal
    {
        #region Public Methods

        /// <summary>查询管理员 所有数据</summary>
        /// <returns>AdminCollection 包含所有记录.</returns>
        public static AdminCollection GetList()
        {
            AdminCollection tempList = new AdminCollection();
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocAdminSelectList", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;
                    myConnection.Open();
                    using (SqlDataReader myReader = myCommand.ExecuteReader())
                    {
                        if (myReader.HasRows)
                        {
                            tempList = new AdminCollection();
                            while (myReader.Read())
                            {
                                tempList.Add(FillDataRecord(myReader));
                            }
                        }
                        myReader.Close();
                    }
                }
            }
            return tempList;
        }


        /// <summary>查询一条管理员记录</summary>
        /// <param name="myAdmin">admin 模型</param>
        /// <returns>Admin模型 包含一条管理员记录.</returns>
        public static Admin GetItem(Admin myAdmin)
        {
            Admin tempAdmin = new Admin();
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocAdminSelectItem", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;
                    if (myAdmin.admin_id > 0)
                    {
                        myCommand.Parameters.AddWithValue("@admin_id", myAdmin.admin_id);
                    }
                    else if (!string.IsNullOrEmpty(myAdmin.username) && !string.IsNullOrEmpty(myAdmin.password))
                    {
                        myCommand.Parameters.AddWithValue("@username", myAdmin.username);
                        myCommand.Parameters.AddWithValue("@password", myAdmin.password);
                    }
                    else
                    {
                        myCommand.Parameters.AddWithValue("@username", myAdmin.username);
                    }
                    myConnection.Open();
                    using (SqlDataReader myReader = myCommand.ExecuteReader())
                    {
                        if (myReader.HasRows)
                        {
                            if (myReader.Read())
                            {
                                tempAdmin = FillDataRecord(myReader);
                            }
                        }
                        myReader.Close();
                    }
                }
            }
            return tempAdmin;
        }


        /// <summary>删除一条管理员记录</summary>
        /// <param name="admin_id">管理员ID</param>
        /// <returns>返回 <c>true</c> 删除成功, 或 <c>false</c> 删除失败.</returns>
        public static bool Delete(int admin_id)
        {
            int result = 0;
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocAdminDeleteSingleItem", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;
                    myCommand.Parameters.AddWithValue("@admin_id", admin_id);
                    myConnection.Open();
                    result = myCommand.ExecuteNonQuery();
                }
            }
            return result > 0;
        }



        /// <summary>修改管理员记录</summary>
        /// <param name="myAdmin">admin 模型</param>
        /// <returns>返回 <c>true</c> 修改成功, 或 <c>false</c> 修改失败.</returns>
        public static bool Update(Admin myAdmin)
        {
            int result = 0;
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocAdminUpdateSingleItem", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;
                    myCommand.Parameters.AddWithValue("@admin_id", myAdmin.admin_id);
                    if (!string.IsNullOrEmpty(myAdmin.password))
                    {
                        myCommand.Parameters.AddWithValue("@password", myAdmin.password);
                    }
                    else
                    {
                        myCommand.Parameters.AddWithValue("@login_ip", myAdmin.login_ip);
                        myCommand.Parameters.AddWithValue("@login_date", myAdmin.login_date);
                    }

                    myConnection.Open();
                    result = myCommand.ExecuteNonQuery();

                }
            }
            return result > 0;
        }





        /// <summary>插入一条管理员记录</summary>
        /// <param name="myAdmin">admin模型</param>
        /// <returns>返回 <c>true</c> 插入成功, 或 <c>false</c> 插入失败.</returns>
        public static bool Insert(Admin myAdmin)
        {
            int result = 0;
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocAdminInsert", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;

                    myCommand.Parameters.AddWithValue("@username", myAdmin.username);
                    myCommand.Parameters.AddWithValue("@password", myAdmin.password);
                    myCommand.Parameters.AddWithValue("@joindate", myAdmin.joindate);
                    myCommand.Parameters.AddWithValue("@login_ip", myAdmin.login_ip);
                    myCommand.Parameters.AddWithValue("@login_date", myAdmin.login_date);

                    myConnection.Open();
                    result = myCommand.ExecuteNonQuery();
                }
            }
            return result > 0;
        }




        #endregion


        #region Private Methods

        /// <summary>
        /// 初始化一个admin类实例，并填充数据。
        /// </summary>
        private static Admin FillDataRecord(IDataRecord myDataRecord)
        {

            Admin myAdmin = new Admin();

            myAdmin.admin_id = myDataRecord.GetInt32(myDataRecord.GetOrdinal("admin_id"));
            myAdmin.username = myDataRecord.GetString(myDataRecord.GetOrdinal("username"));
            myAdmin.password = myDataRecord.GetString(myDataRecord.GetOrdinal("password"));
            myAdmin.joindate = myDataRecord.GetDateTime(myDataRecord.GetOrdinal("joindate"));

            if (!myDataRecord.IsDBNull(myDataRecord.GetOrdinal("login_ip")))
            {
                myAdmin.login_ip = myDataRecord.GetString(myDataRecord.GetOrdinal("login_ip"));
            }
            if (!myDataRecord.IsDBNull(myDataRecord.GetOrdinal("login_date")))
            {
                myAdmin.login_date = myDataRecord.GetDateTime(myDataRecord.GetOrdinal("login_date"));
            }
            return myAdmin;
        }

        #endregion
    }
}
