﻿// -----------------------------------------------------------------------
// <copyright file="ArticleDal.cs" project="EnterpriseWeb.Dal" ver="1.0">
//   Copyright 2009 - 2009 - JRJJ. All rights reserved.
// </copyright>
// -----------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using System.Data.SqlClient;
using EnterpriseWeb.Model;

namespace EnterpriseWeb.Dal
{
    /// <summary>
    /// 文章管理 Dal
    /// </summary>
    public static class ArticleDal
    {
        #region Public Methods

        /// <summary>查询文章 所有数据</summary>
        /// <returns>ArticleCollection 包含所有记录.</returns>
        public static ArticleCollection GetList(int ac_id, int startRowIndex, int maximumRows, string orderBy)
        {
            ArticleCollection tempList = new ArticleCollection();
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocArticleSelectList", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;

                    myCommand.Parameters.AddWithValue("@ac_id", ac_id);
                    if (startRowIndex > 0 && maximumRows > 0)
                    {
                        myCommand.Parameters.AddWithValue("@startRowIndex", startRowIndex);
                        myCommand.Parameters.AddWithValue("@maximumRows", maximumRows);
                    }
                    if (!string.IsNullOrEmpty(orderBy))
                    {
                        myCommand.Parameters.AddWithValue("@orderBy", orderBy);
                    }
                    myConnection.Open();
                    using (SqlDataReader myReader = myCommand.ExecuteReader())
                    {
                        if (myReader.HasRows)
                        {
                            tempList = new ArticleCollection();
                            while (myReader.Read())
                            {
                                tempList.Add(FillDataRecord(myReader));
                            }
                        }
                        myReader.Close();
                    }
                }
            }
            return tempList;
        }



        /// <summary>条件查询文章 </summary>
        /// <param name="istop">置顶</param>
        /// <param name="iscommend">推荐</param>
        /// <returns>ArticleCollection 包含条件查询的记录.</returns>
        public static ArticleCollection GetList(bool istop, bool iscommend)
        {
            ArticleCollection tempList = new ArticleCollection();
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocArticleSearchList", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;

                    if (istop)
                    {
                        myCommand.Parameters.AddWithValue("@istop", istop);
                    }
                    if (iscommend)
                    {
                        myCommand.Parameters.AddWithValue("@iscommend", iscommend);
                    }

                    myConnection.Open();
                    using (SqlDataReader myReader = myCommand.ExecuteReader())
                    {
                        if (myReader.HasRows)
                        {
                            tempList = new ArticleCollection();
                            while (myReader.Read())
                            {
                                tempList.Add(FillDataRecord(myReader));
                            }
                        }
                        myReader.Close();
                    }
                }
            }
            return tempList;
        }


        /// <summary>条件查询文章 </summary>
        /// <param name="art_id">文章ID</param>
        /// <returns>Article模型 包含一条文章记录.</returns>
        public static Article GetItem(int art_id)
        {
            Article myArticle = new Article();
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocArticleSelectItem", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;
                    myCommand.Parameters.AddWithValue("@art_id", art_id);
                    myConnection.Open();
                    using (SqlDataReader myReader = myCommand.ExecuteReader())
                    {
                        if (myReader.HasRows)
                        {
                            if (myReader.Read())
                            {
                                myArticle = FillDataRecord(myReader);
                            }
                        }
                    }
                }
            }
            return myArticle;
        }


        /// <summary>删除一条文章记录</summary>
        /// <param name="art_id">文章ID</param>
        /// <returns>返回 <c>true</c> 删除成功, 或 <c>false</c> 删除失败.</returns>
        public static bool Delete(int art_id)
        {
            int result = 0;
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocArticleDeleteSingleItem", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;
                    myCommand.Parameters.AddWithValue("@art_id", art_id);
                    myConnection.Open();
                    result = myCommand.ExecuteNonQuery();
                }
            }
            return result > 0;
        }


        /// <summary>修改文章点击数</summary>
        /// <param name="art_id">文章ID</param>
        /// <returns>返回 <c>true</c> 修改成功, 或 <c>false</c> 修改失败.</returns>
        public static bool Update(int art_id)
        {
            int result = 0;
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocArticleUpdateSingleClick", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;
                    myCommand.Parameters.AddWithValue("@art_id", art_id);

                    myConnection.Open();
                    result = myCommand.ExecuteNonQuery();
                }
            }
            return result > 0;
        }


        /// <summary>修改文章</summary>
        /// <param name="myArticle">文章模型</param>
        /// <returns>返回 <c>true</c> 修改成功, 或 <c>false</c> 修改失败.</returns>
        public static bool Update(Article myArticle)
        {
            int result = 0;
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocArticleUpdateSingleItem", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;

                    myCommand.Parameters.AddWithValue("@art_id", myArticle.art_id);
                    myCommand.Parameters.AddWithValue("@art_title", myArticle.art_title);
                    myCommand.Parameters.AddWithValue("@art_author", myArticle.art_author);
                    myCommand.Parameters.AddWithValue("@art_from", myArticle.art_from);
                    myCommand.Parameters.AddWithValue("@art_content", myArticle.art_content);
                    myCommand.Parameters.AddWithValue("@art_description", myArticle.art_description);
                    myCommand.Parameters.AddWithValue("@art_date", myArticle.art_date);
                    myCommand.Parameters.AddWithValue("@art_image", myArticle.art_image);
                    myCommand.Parameters.AddWithValue("@istop", myArticle.istop);
                    myCommand.Parameters.AddWithValue("@iscommend", myArticle.iscommend);
                    myCommand.Parameters.AddWithValue("@ac_id", myArticle.ac_id);

                    myConnection.Open();
                    result = myCommand.ExecuteNonQuery();
                }
            }
            return result > 0;
        }


        /// <summary>插入文章记录</summary>
        /// <param name="myArticle">myArticle 模型</param>
        /// <returns>返回 <c>true</c> 插入成功, 或 <c>false</c> 插入失败.</returns>
        public static bool Insert(Article myArticle)
        {
            int result = 0;
            using (SqlConnection myConnection = new SqlConnection(AppConfiguration.ConnectionString))
            {
                using (SqlCommand myCommand = new SqlCommand("sprocArticleInsert", myConnection))
                {
                    myCommand.CommandType = CommandType.StoredProcedure;

                    myCommand.Parameters.AddWithValue("@art_title", myArticle.art_title);
                    myCommand.Parameters.AddWithValue("@art_author", myArticle.art_author);
                    myCommand.Parameters.AddWithValue("@art_from", myArticle.art_from);
                    myCommand.Parameters.AddWithValue("@art_content", myArticle.art_content);
                    myCommand.Parameters.AddWithValue("@art_description", myArticle.art_description);
                    myCommand.Parameters.AddWithValue("@art_date", myArticle.art_date);
                    myCommand.Parameters.AddWithValue("@art_image", myArticle.art_image);
                    myCommand.Parameters.AddWithValue("@art_click", myArticle.art_click);
                    myCommand.Parameters.AddWithValue("@istop", myArticle.istop);
                    myCommand.Parameters.AddWithValue("@iscommend", myArticle.iscommend);
                    myCommand.Parameters.AddWithValue("@ac_id", myArticle.ac_id);

                    myConnection.Open();
                    result = myCommand.ExecuteNonQuery();
                }
            }
            return result > 0;
        }


        #endregion


        #region Private Methods

        /// <summary>
        /// 初始化一个Article类实例，并填充数据。
        /// </summary>
        private static Article FillDataRecord(IDataRecord myDataRecord)
        {
            Article myArticle = new Article();

            myArticle.art_id = myDataRecord.GetInt32(myDataRecord.GetOrdinal("art_id"));
            myArticle.art_title = myDataRecord.GetString(myDataRecord.GetOrdinal("art_title"));
            myArticle.art_content = myDataRecord.GetString(myDataRecord.GetOrdinal("art_content"));
            myArticle.art_date = myDataRecord.GetDateTime(myDataRecord.GetOrdinal("art_date"));
            myArticle.ac_id = myDataRecord.GetInt32(myDataRecord.GetOrdinal("ac_id"));
            
            if (!myDataRecord.IsDBNull(myDataRecord.GetOrdinal("art_author")))
            {
                myArticle.art_author = myDataRecord.GetString(myDataRecord.GetOrdinal("art_author"));
            }
            if (!myDataRecord.IsDBNull(myDataRecord.GetOrdinal("art_from")))
            {
                myArticle.art_from = myDataRecord.GetString(myDataRecord.GetOrdinal("art_from"));
            }
            if (!myDataRecord.IsDBNull(myDataRecord.GetOrdinal("art_description")))
            {
                myArticle.art_description = myDataRecord.GetString(myDataRecord.GetOrdinal("art_description"));
            }
            if (!myDataRecord.IsDBNull(myDataRecord.GetOrdinal("art_image")))
            {
                myArticle.art_image = myDataRecord.GetString(myDataRecord.GetOrdinal("art_image"));
            }
            if (!myDataRecord.IsDBNull(myDataRecord.GetOrdinal("art_click")))
            {
                myArticle.art_click = myDataRecord.GetInt32(myDataRecord.GetOrdinal("art_click"));
            }
            if (!myDataRecord.IsDBNull(myDataRecord.GetOrdinal("istop")))
            {
                myArticle.istop = myDataRecord.GetBoolean(myDataRecord.GetOrdinal("istop"));
            }
            if (!myDataRecord.IsDBNull(myDataRecord.GetOrdinal("iscommend")))
            {
                myArticle.iscommend = myDataRecord.GetBoolean(myDataRecord.GetOrdinal("iscommend"));
            }
            return myArticle;
        }

        #endregion
    }
}
